//  (c) 2004. All Rights Reserved.  DoubleClick Inc.
var g_adParameters = "";
var g_mediaServer = "";
var g_dartIsInPreviewMode = "";
var g_globalTemplateVersion = "";
var g_creativeType = "";
var g_creativeIdentifier = "";
var g_fullScreenVideoEnabled = false;
var g_hasSlaves = false;
var g_numberOfSlaves = 0;

var g_iframeIndex = -1;
var g_displayWindow = null;
var g_adIFrame = null;

var g_slaveIndex = -1;
var g_isSlaveReady = false;
var g_creativeRemoved = false;
var g_isTzCreative = false;
var g_tzAutoContract = true;
var g_tzOverlayToPlacement = false;
var g_mtfNoFlush = false;

function extractIFrameParameters() {
    var searchString = document.location.search.substr(1);
    var iframeParameters = searchString.split('&');

    for(var i = 0; i < iframeParameters.length; i++) {
        var keyValuePair = iframeParameters[i].split('=');
        var parameterName = keyValuePair[0];
        var parameterValue = keyValuePair[1];

        if(parameterName == "adParams")
            g_adParameters = parameterValue;
        else if(parameterName == "gtVersion")
            g_globalTemplateVersion = unescape(parameterValue);
        else if(parameterName == "mediaserver")
            g_mediaServer = unescape(parameterValue);
        else if(parameterName == "previewMode")
            g_dartIsInPreviewMode = unescape(parameterValue) == "true";
        else if(parameterName == "creativeType")
            g_creativeType = unescape(parameterValue).toUpperCase();
        else if(parameterName == "cid")
            g_creativeIdentifier = unescape(parameterValue);
        else if(parameterName == "index")   // The slaves will have index.
            g_slaveIndex = parseInt(unescape(parameterValue));
        else if(parameterName == "isFSV" && parameterValue == "true")
            g_fullScreenVideoEnabled = true;
        else if(parameterName == "needSlaves")
            g_hasSlaves = parameterValue;
        else if(parameterName == "numberOfSlaves")
            g_numberOfSlaves = parameterValue;
		else if(parameterName == "isTz")
			g_isTzCreative = (parameterValue=="true") ? true : false;
		else if(parameterName == "tzAutoContract")
			g_tzAutoContract = (parameterValue=="true") ? true : false;
		else if(parameterName == "tzOverlayToPlacement")
			g_tzOverlayToPlacement = (parameterValue=="true") ? true : false;
        else if(parameterName == "mtfNoFlush")
			g_mtfNoFlush = (parameterValue=="true") ? true : false;
    }
}

function getAdParameters() {
    return g_adParameters;
}

function isMasterIFrame() {
    return (g_slaveIndex == -1);
}

function getCreativeIdentifier() {
    return g_creativeIdentifier;
}

function isFullScreenVideoEnabled() {
    return g_fullScreenVideoEnabled;
}

function isSlaveIFrame(iframeWindow) {
    try {
        var slaveName = iframeWindow.name;
        if(iframeWindow != self && slaveName && slaveName != "") {
            var underscoreIndex = slaveName.lastIndexOf("_");
            var slaveCid = slaveName.substring(0, underscoreIndex);
            if(slaveCid == getCreativeIdentifier() && !isNaN(slaveName.substring(underscoreIndex + 1)))
                return true;
        }
    }
    catch(e) { }
    return false;
}

function hasSlaveIFrames() {
    return (g_hasSlaves == "true");
}

function findAdIframe() {
    var topWindow = top;
    var currentWindow = self;
    var parentWindow = null;
	var breakOutWindow = null;
    var previousFrameIndex = -1;
    var currentFrameIndex = -1;
    var skip0x0IFrame = true;

    do {
        parentWindow = currentWindow.parent;
        if(skip0x0IFrame == true) { //Need to skip first 0x0 Iframe.
            skip0x0IFrame = false;
        }
        else {
            var frames = parentWindow.frames;
            for(var i = 0; i < frames.length; i++) {
                if(frames[i] == currentWindow) {
                    currentFrameIndex = i;
                    break;
                }
            }
            if(!hasAccess(parentWindow)) {
                checkAccessByDownGradingDomain(parentWindow);
                parentWindow = reCalculateWindowReference(parentWindow);
            }
            if(parentWindow.document.getElementsByTagName("frame").length != 0) {
                break;
            }
        }
        previousFrameIndex = currentFrameIndex;
		breakOutWindow = currentWindow;
        currentWindow = parentWindow;
    } while(currentWindow != topWindow)

    if(currentWindow == topWindow) {
        g_displayWindow = currentWindow;
        g_iframeIndex = currentFrameIndex;
    }
    else {  //Page has Frames.
        g_displayWindow = currentWindow;
        g_iframeIndex = previousFrameIndex;
    }
    if(g_iframeIndex == -1)
        return null;

	if (isSafari())
	{
		var frameList = g_displayWindow.document.getElementsByTagName("iframe");
		if(g_iframeIndex >= frameList.length)
			return null;
		g_adIFrame = frameList[g_iframeIndex];
	}
	else
	{
		var iframeElements = g_displayWindow.document.getElementsByTagName("iframe");
		for (var k = 0; k < iframeElements.length; k++)
		{
			var iframeEle = iframeElements[k];
			if (iframeEle.contentWindow == breakOutWindow)
			{
				g_adIFrame = iframeEle;
			}
		}
	}

    g_adIFrame.MotifIFrameID = g_creativeIdentifier;
    g_adIFrame.dartGlobalTemplateVersion = g_globalTemplateVersion;
}

function findInnerMostAdIFrame() {
    var parentWindow = self.parent;
    g_displayWindow = parentWindow.parent;
    var frames = g_displayWindow.frames;
    for(var i = 0; i < frames.length; i++) {
        if(frames[i] == parentWindow) {
            g_iframeIndex = i;
            break;
        }
    }
    if(!hasAccess(g_displayWindow)) {
        checkAccessByDownGradingDomain(g_displayWindow);
        g_displayWindow = reCalculateWindowReference(g_displayWindow)
    }

	var iframeElements = g_displayWindow.document.getElementsByTagName("iframe");
	for (var k = 0; k < iframeElements.length; k++)
	{
		var iframeEle = iframeElements[k];
		if (iframeEle.contentWindow == self.parent)
		{
			g_adIFrame = iframeEle;
		}
	}

	if (isSafari() && g_adIFrame == null)
	{
		var frameList = g_displayWindow.document.getElementsByTagName("iframe");
		if(g_iframeIndex >= frameList.length)
			return null;
		g_adIFrame = frameList[g_iframeIndex];
	}

    g_adIFrame.MotifIFrameID = g_creativeIdentifier;
    g_adIFrame.dartGlobalTemplateVersion = g_globalTemplateVersion;
}

function checkAccessByDownGradingDomain(parentWindow) {
    var selfDomain = self.document.domain;
    while(selfDomain.split(".").length > 2) {
        var newDomain = selfDomain.substr(selfDomain.indexOf(".") + 1);
        self.document.domain = newDomain;
        parentWindow = reCalculateWindowReference(parentWindow);
        if(hasAccess(parentWindow)) {
            break;
        }
        selfDomain = newDomain;
    }
}

function hasAccess(winRef) {
    try {
        winRef.document.getElementsByTagName("div");
        return true;
    } catch(e) {
        return false;
    }
}

/* After downgrading "self" domain, the parent window reference needs to be recalculated. */
function reCalculateWindowReference(winRef) {
    var currWin = self;
    while(currWin != winRef && currWin != top) {
        currWin = currWin.parent;
    }
    return (currWin == winRef) ? currWin : null;
}

function startLoadingGlobalTemplateScript() {
    if(isLoadingGlobalTemplateScript())
        return;
    evaluateVariableInDisplayWindow("loadingDartGlobalTemplate_" + g_globalTemplateVersion, true);
    var scriptTag = g_displayWindow.document.createElement("SCRIPT");
    scriptTag.src = g_mediaServer + "/globalTemplateIframe_" +  g_globalTemplateVersion + ".js";
    var displayPageDocument = g_adIFrame.parentNode;
    displayPageDocument.insertBefore(scriptTag, g_adIFrame);
}

function isLoadingGlobalTemplateScript() {
    var varName = "g_displayWindow.loadingDartGlobalTemplate_" + g_globalTemplateVersion;
    if(eval("typeof(" + varName + ")") != "undefined" && eval(varName) == true)
        return true;
    return false;
}

function isGlobalTemplateScriptLoaded() {
    var varName = "g_displayWindow.dartGlobalTemplateLoaded_" + g_globalTemplateVersion;
    if(eval("typeof(" + varName + ")") != "undefined" && eval(varName) == true)
        return true;
    return false;
}

function writeAdParamsToDisplayWindow() {
    var iframeObject = "dartIFrameCreative_" + g_creativeIdentifier + "_" + g_globalTemplateVersion;
    var obj = new Object();
    obj.creativeInfo = g_adParameters;
    obj.creativeType = g_creativeType;
    obj.mediaServer = g_mediaServer.substring(0, g_mediaServer.lastIndexOf("/"));
    obj.fullScreenVideoEnabled = isFullScreenVideoEnabled();
    obj.isTzCreative = g_isTzCreative;
    obj.tzAutoContract = g_tzAutoContract;
    obj.tzOverlayToPlacement = g_tzOverlayToPlacement;
    obj.mtfNoFlush = g_mtfNoFlush;
    evaluateVariableInDisplayWindow(iframeObject, obj);
}

function getCreativeParameters() {
    return g_adParameters;
}

function getCreativeType() {
    return g_creativeType;
}

function isInterstitialPlaying() {
    return (typeof(g_displayWindow.DoNotDisplayIA) == "number") ? true : false;
}

function setInterstitialPlaying() {
    evaluateVariableInDisplayWindow("DoNotDisplayIA", 1);
}

function setPreviewMode() {
    evaluateVariableInDisplayWindow("doubleClick_dartIsInPrevMode", g_dartIsInPreviewMode);
}

function evaluateVariableInDisplayWindow(name, value) {
    g_displayWindow[name] = value;
}

function processIFramebreakout() {
    g_adParameters = collectAdParametersFromAllIFrames();
    if(g_creativeType == "FLOATING" || g_creativeType == "FLOATINGWITHREMINDER") {
        if(isInterstitialPlaying()) {
            return;
        }
        setInterstitialPlaying();
    }
    setPreviewMode();
    if(isDisplayWindowLoaded() && isGlobalTemplateScriptLoaded()) {
        var script = "(new g_displayWindow.DARTIFrame_" + g_globalTemplateVersion + "())";
        var iframeObj = eval(script);
        var obj = new Object();
        obj.creativeInfo = g_adParameters;
        obj.creativeType = g_creativeType;
        obj.mediaServer = g_mediaServer.substring(0, g_mediaServer.lastIndexOf("/"));
        obj.fullScreenVideoEnabled = isFullScreenVideoEnabled();
        obj.isTzCreative = g_isTzCreative;
    	obj.tzAutoContract = g_tzAutoContract;
    	obj.tzOverlayToPlacement = g_tzOverlayToPlacement;
        obj.mtfNoFlush = g_mtfNoFlush;
        iframeObj.doIFrameBreakout(obj, g_creativeIdentifier);
    }
    else {
        writeAdParamsToDisplayWindow();
        if(!isGlobalTemplateScriptLoaded())
            startLoadingGlobalTemplateScript();
    }
    registerUnloadHandler();
}

function isSlaveIFramesLoaded() {
    var slaves = self.parent.frames;
    var countSlavesLoaded = 0;
    for(var i = 0; i < slaves.length; i++) {
        if(isSlaveIFrame(slaves[i])) {
            if((typeof(slaves[i].g_isSlaveReady) == "undefined") || (slaves[i].g_isSlaveReady != true))
                return false;
            else
                countSlavesLoaded++;
        }
    }

    if(countSlavesLoaded != g_numberOfSlaves)
        return false;

    return true;
}

function collectAdParametersFromAllIFrames() {
    var adParameters = getAdParameters();
    if(!hasSlaveIFrames())
        return unescape(adParameters);

    var slaves = self.parent.frames;
    for(var i = 0; i < slaves.length; i++) {
        if(isSlaveIFrame(slaves[i]))
            adParameters += slaves[i].getAdParameters();
    }
    return unescape(adParameters);
}

function waitForSlavesAndProcessBreakout() {
    if(!isSlaveIFramesLoaded())
        window.setTimeout("waitForSlavesAndProcessBreakout()", 200);
    else
        processIFramebreakout();
}

function indicateSuccessToParent() {
    document.write("<IFRAME name='DARTMotifIFrame' SRC='about:blank' width='0px' height='0px' frameborder='0' scrolling='no'></IFRAME>");
}

function isInternetExplorer() {
    return (navigator.appVersion.indexOf("MSIE") != -1 && navigator.userAgent.indexOf("Opera") < 0);
}

function isFirefox() {
    return (navigator.userAgent.toUpperCase().indexOf("FIREFOX") != -1);
}

function isSafari() {
    return (navigator.appVersion.indexOf("Safari") != -1);
}

function setOnLoadFlagForTopWindow() {
    g_displayWindow.g_motifPageLoadedFlag = true;
}

function registerUnloadHandler() {
    if(isInternetExplorer()) {
        self.attachEvent("onunload", onUnload);
        self.attachEvent("onbeforeunload", onBeforeUnLoad);
    }
    else {
        self.addEventListener("unload", onBeforeUnLoad, true);
    }
}

function removeCreative() {
    if(isGlobalTemplateScriptLoaded()) {
        var script = "(new g_displayWindow.DARTIFrame_" + g_globalTemplateVersion + "())";
        var iframeObj = eval(script);
        iframeObj.removeCreative(g_creativeIdentifier, g_creativeType, false);
    }
}

function onBeforeUnLoad() {
    removeCreative();
    g_creativeRemoved = true;
}

function onUnload() {
    if(!g_creativeRemoved) {
        removeCreative();
    }
}

function isDisplayWindowLoaded() {
    if(isInternetExplorer())
        return g_displayWindow.document.readyState.toLowerCase() == "complete";
    return true;
}

try {
    extractIFrameParameters();
    indicateSuccessToParent();
    if(isMasterIFrame()) {
        if(g_creativeType == "FLOATING" || g_creativeType == "FLOATINGWITHREMINDER") {
            findAdIframe();
        }
        else {
            findInnerMostAdIFrame();
        }
        if(isFirefox() && typeof(g_displayWindow.g_motifPageLoadedFlag) == "undefined") { //readyState workaround for Firefox.
            g_displayWindow.g_motifPageLoadedFlag = false;
            g_displayWindow.pageLoadCallback = new Function("g_displayWindow.g_motifPageLoadedFlag = true;");
            g_displayWindow.addEventListener("load", g_displayWindow.pageLoadCallback, true);
        }
        if(hasSlaveIFrames())
            waitForSlavesAndProcessBreakout();
        else
            processIFramebreakout();
    }
    else {
        g_isSlaveReady = true;
    }
}
catch(e) {}

