
//  (c) 2006. All Rights Reserved.  DoubleClick Inc.

if(typeof(dartMotifCreatives) == "undefined")
	var dartMotifCreatives = new Array();
if(typeof(dartCallbackObjects) == "undefined")
	var dartCallbackObjects = new Array();
if(typeof(dartGlobalTemplateObjects) == "undefined")
	var dartGlobalTemplateObjects = new Array();
if(typeof(dartCreativeDisplayManagers) == "undefined")
	var dartCreativeDisplayManagers = new Array();
if(typeof(dartFSVManagers) == "undefined")
	var dartFSVManagers = new Array();

function DARTCreativeDisplayManager_20_21(creative) {
	this.creative = creative;
	this.creativeIdentifier = creative.creativeIdentifier;
	this.previewMode = creative.previewMode;
	this.debugEventsMode = creative.debugEventsMode;
	this.renderingId = creative.renderingId;
	this.creativeType = creative.type;
    this.mtfNoFlush = creative.mtfNoFlush;

	this.dartPopupArray = new Array();
	this.dartEntityPropertiesArray = new Array();
	this.noAdjustElements = new _doNotAdjustElement();
	this.isDisplayTimerRunning = false;
	this.fsCommandHandlers = new Array();
	this.rootElementArray = new Array();

	this.globalTemplate = dartGlobalTemplateObjects[this.creativeIdentifier];
	this.browser = new DARTBrowser_20_21(this.globalTemplate);
	this.isTzCreative = creative.isTzCreative;
	this.tzAutoContract = creative.tzAutoContract;
	this.tzOverlayToPlacement = creative.tzOverlayToPlacement;
    
    this.useJSMouseOutToCollapse = this.isTzCreative && this.tzAutoContract && !this.tzOverlayToPlacement;
    this.reloadOnCollapse = this.isTzCreative && !this.tzOverlayToPlacement;
    this.stopExpandingTimerOnCollapse = this.isTzCreative;
    
	this.dartEventBin = null;
	if(!this.previewMode) {
		this.dartEventBin = new DARTEventBin_20_21(this.creativeIdentifier, this.globalTemplate, this.mtfNoFlush);
	}
	else if(this.debugEventsMode && this.creativeType == "Pop") {
		if (typeof(opener) != "undefined")
			this.dartDebugEventBin = opener.dartGlobalTemplateObjects[this.creativeIdentifier].debugEventBin;
		else
			this.dartDebugEventBin = parent.dartGlobalTemplateObjects[this.creativeIdentifier].debugEventBin;
		var callback = new Function("try { dartCreativeDisplayManagers['" + this.creativeIdentifier + "'].setShouldFlush('" + this.renderingId + "', false); } catch(e) {}");
		self.attachEvent("onunload", callback);
	}

	this.assets = new Array();
	for(var type in creative.assets) {
		if (!this.globalTemplate.isPartOfArrayPrototype(type))
			this.assets[creative.assets[type].variableName] = creative.assets[type];
	}

	this.deleteCreative = function(removeOnlyJSObjects) {
		this.deleteJSObjects();
		if(!removeOnlyJSObjects) {
			this.deleteHTMLObjects();
		}
	}

	this.deleteHTMLObjects = function() {
		for(var i = 0; i < this.rootElementArray.length; i++) {
			if(this.rootElementArray[i] != null && this.rootElementArray[i].parentNode != null)
				this.removeChildNode(this.rootElementArray[i], this.rootElementArray[i].parentNode);
		}
	}

	this.deleteJSObjects = function() {
		if(this.creativeType == "FloatingFlash" || this.creativeType == "FloatingFlashReminderFlash")
			DoNotDisplayIA = null;

		this.detachFSCommandHandler();
		this.setShouldFlush(this.renderingId, false);

		if(this.creative.isFSV) {
			var fsvManager = dartFSVManagers["FSV_" + this.creativeIdentifier];
			fsvManager.deleteFSVCreative();
			this.globalTemplate.removeArrayElement(dartCallbackObjects, fsvManager);
			dartFSVManagers["FSV_" + this.creativeIdentifier] = null;
		}

		this.globalTemplate.removeArrayElement(dartCallbackObjects, this.dartEventBin);
		this.dartEventBin = null;

		this.globalTemplate.removeArrayElement(dartCallbackObjects, this.globalTemplate);
		this.globalTemplate = null;
		dartGlobalTemplateObjects[this.creativeIdentifier] = null;
	}

	function fsHook(variableName) {
		var str = "";
		str += variableName + '_DoFSCommand = function(command, args) { \n';
		str += '    if(dartCreativeDisplayManagers["' + this.creativeIdentifier + '"] != null) dartCreativeDisplayManagers["' + this.creativeIdentifier + '"].FSCommandHandler(command, args);\n';
		str += '}\n';
		window.eval(str);

		if(this.globalTemplate.isInternetExplorer()) {
			var flashObj = this.globalTemplate.toObject(variableName);
			var pointer = eval(variableName + "_DoFSCommand");
			this.fsCommandHandlers[variableName] = pointer;
			if(flashObj.attachEvent("FSCommand", pointer))
				this.globalTemplate.registerPageUnLoadHandler("detachFSCommandHandler()", this);
		}
	}
	this.fsHook = fsHook;

	this.registerFSCommandHandler = function(assetId) {
		if(this.globalTemplate.isInternetExplorer()) {
			var flashObj = this.globalTemplate.toObject("FLASH_" + assetId);
			var pointer = this.fsCommandHandlers["FLASH_" + assetId];
			if(flashObj.attachEvent("FSCommand", pointer))
				this.globalTemplate.registerPageUnLoadHandler("detachFSCommandHandler()", this);
		}
	}

	function detachFSCommandHandler() {
		for(var varName in this.assets) {
			if(!this.globalTemplate.isPartOfArrayPrototype(varName)) {
				var variableName = "FLASH_" + varName;
				var flashObj = this.globalTemplate.toObject(variableName);
				var pointer = this.fsCommandHandlers[variableName];
				if(flashObj != null) {
					if(this.globalTemplate.isInternetExplorer())
						flashObj.detachEvent("FSCommand", pointer);
				}
			}
		}
	}
	this.detachFSCommandHandler = detachFSCommandHandler;

	function FSCommandHandler(command, args) {
		var argArray = this._splitArgs(args);
		var functionCall = command + "(";
		var count = 0;
		for(var k = 0; k < argArray.length; k++) {
			if(count > 0)
				functionCall += ", ";
			functionCall += "\"" + argArray[k] + "\"";
			count++;
		}
		functionCall += ")";
		try {
			return eval("dartCreativeDisplayManagers[\"" + this.creativeIdentifier + "\"]." + functionCall);
		}
		catch(e) {
			try {eval(functionCall);}
			catch(e) {}
		}
	}
	this.FSCommandHandler = FSCommandHandler;

	function conduitInitialized(assetName) {
		var asset = this.getAsset(assetName);
		asset.conduitInitialized = true;
	}
	this.conduitInitialized = conduitInitialized;

	function getEventBin() {
		if(!this.previewMode)
			return this.dartEventBin;
		else if(this.debugEventsMode)
			return this.dartDebugEventBin;
		else
			return null;
	}
	this.getEventBin = getEventBin;

	function logEvent(eventType, eventId, erid, isCumulative) {
		if(eventId == "2") {
			this.logDisplayTimerEvent(eventType, erid);
		}
		else {
			var eventBin = this.getEventBin();
			if(eventBin)
				eventBin.logMetEvent(eventType, eventId, erid, isCumulative);
		}
	}
	this.logEvent = logEvent;

	function stopStandardTimers(rid) {
		this.logEvent("Stop", "2", rid);
		this.logEvent("Stop", "3", rid);
		this.logEvent("Stop", "7", rid);
		this.logEvent("Stop", "12", rid);
	}
	this.stopStandardTimers = stopStandardTimers;

	function logDisplayTimerEvent(eventType, erid) {
		var eventBin = this.getEventBin();
		if(eventType == "Start") {
			if(!this.isDisplayTimerRunning) {
				if(eventBin)
					eventBin.logMetEvent("Start", "2", erid);
				this.isDisplayTimerRunning = true;
			}
		}
		else if(eventType == "Stop") {
			if(this.isDisplayTimerRunning) {
				if(eventBin)
					eventBin.logMetEvent("Stop", "2", erid);
				this.isDisplayTimerRunning = false;
			}
		}
	}
	this.logDisplayTimerEvent = logDisplayTimerEvent;

	function flushCounters(erid) {
		var eventBin = this.getEventBin();
		if(eventBin)
			eventBin.flushMetCounters(erid);
	}
	this.flushCounters = flushCounters;

	function setShouldFlush(erid, flag) {
		var eventBin = this.getEventBin();
		if(eventBin)
			eventBin.setMetShouldFlush(erid, flag);
	}
	this.setShouldFlush = setShouldFlush;

	function getShouldFlush(erid) {
		var eventBin = this.getEventBin();
		return (eventBin && eventBin.getShouldFlush(erid));
	}
	this.getShouldFlush = getShouldFlush;

	function registerUrl(erid, adServerUrl, startTime) {
		var eventBin = this.getEventBin();
		if(eventBin)
			eventBin.registerEventBinUrl(erid, adServerUrl, startTime);
	}
	this.registerUrl = registerUrl;

	function _logEventFlushCounters(eventType, eventId, erid) {
		this.logEvent(eventType, eventId, erid, true);
		this.flushCounters(erid);
	}
	this._logEventFlushCounters = _logEventFlushCounters;

	function _logEventFlushCountersOpenPopup(eventType, eventId, erid, url, dartWindowName, features, isPopUnder) {
		this.logEvent(eventType, eventId, erid, true);
		this.flushCounters(erid);
		this.openPopup(url, dartWindowName, features, isPopUnder);
	}
	this._logEventFlushCountersOpenPopup = _logEventFlushCountersOpenPopup;

	function onMouseOver(assetName) {
		try {
			var flashObject = this.globalTemplate.toObject("FLASH_" + assetName);
			flashObject.TCallFrame("/motifExpandingController", 1);
		}
		catch(e) {
		}
	}
	this.onMouseOver = onMouseOver;

	this.onMouseOut = function(assetName) {
		try {
			if(this.useJSMouseOutToCollapse) {
				this.collapseAsset(assetName);
			} else {
				var flash = this.globalTemplate.toObject("FLASH_" + assetName);
				flash.TCallFrame("/motifExpandingController", 3);
			}
		} catch(e) {}
	}

	this.expandAsset = function(assetId) {
		var variableName = "DIV_" + assetId;
		var exp = this.globalTemplate.toObject(variableName);
		this._adjustWindowElements(assetId, true);
		var asset = this.getAsset(assetId);
		if(asset.pushContents) {
			this.startAnimation(asset, true);
		}
		else {
			if (this.globalTemplate.usesSalignForExpanding(asset.salign, asset.wmode)) {
				var fl = document.getElementById("FLASH_"+assetId);
				fl.style.width = asset.expandedWidth + "px";
				fl.style.height = asset.expandedHeight + "px";
				fl.width = asset.expandedWidth + "px";
				fl.height = asset.expandedHeight + "px";
				fl.style.marginLeft = "0px";
				fl.style.marginTop = "0px";
			}
			exp.style.clip = "rect(auto auto auto auto)";
		}
	}

	this.collapseAsset = function(assetId) {
		var variableName = "DIV_" + assetId;
		var exp = this.globalTemplate.toObject(variableName);
		var asset = this.getAsset(assetId);
		if(asset.pushContents) {
			this.startAnimation(asset, false);
		}
		else {
            if(this.stopExpandingTimerOnCollapse) {
                var rid = this.getRenderingId(assetId);
                this.logEvent("Stop",3,rid);
                this.logEvent("Stop",10,rid);
            }
			if(this.reloadOnCollapse) {
				this.reloadFlash(assetId);
			}
			if(this.globalTemplate.usesSalignForExpanding(asset.salign, asset.wmode)) {
				var fl = document.getElementById("FLASH_"+assetId);
				fl.style.width = asset.width + "px";
				fl.style.height = asset.height + "px";
				fl.width = asset.width + "px";
				fl.height = asset.height + "px";
				fl.style.marginLeft = asset.offsetLeft + "px";
				fl.style.marginTop = asset.offsetTop + "px";
			}
			exp.style.clip = "rect(" + asset.offsetTop + "px " + asset.offsetRight + "px " + asset.offsetBottom + "px " + asset.offsetLeft + "px)";
		}
		this._adjustWindowElements(assetId, false);
	}

	this.reloadFlash = function(assetId) {
		if(this.globalTemplate.isInternetExplorer()) {
			this.detachFSCommandHandler();
		}
		var div = this.globalTemplate.toObject("DIV_" + assetId);
		div.innerHTML = this.getAsset(assetId).flashHtml;
		this.registerFSCommandHandler(assetId);
		this.finishDispatchScriptLoaded(assetId);
	}

	this.startAnimation = function(asset, expandMode) {
		if(asset.animationState == null) {
			var state = new Object();
			state.isRunning = false;
			state.animateCallback = this.globalTemplate.generateGlobalCallback("updateExpandingViewPort(\"" + asset.variableName + "\")", this);
			state.expandMode = true;
			var height = parseInt(asset.height);
			state.currentHeight = height;
			var expandedHeight = parseInt(asset.expandedHeight);
			var expandLenght = expandedHeight - height;
			var animationTime = asset.animationTime * 1000;
			state.updateInterval = 50;
			var totalIntervals = Math.ceil(animationTime / state.updateInterval);
			state.stepLength = Math.ceil(expandLenght / (totalIntervals + 1));
			asset.animationState = state;
		}
		asset.animationState.expandMode = expandMode;
		if(!asset.animationState.isRunning) {
			asset.animationState.isRunning = true;
			this.updateExpandingViewPort(asset.variableName);
		}
	}

	this.updateExpandingViewPort = function(assetId) {
		var asset = this.getAsset(assetId);
		var state = asset.animationState;
		var animationComplete = false;
		var top = "auto";
		var right = "auto";
		var left = "auto";
		if(state.expandMode) {
			var expandedHeight = parseInt(asset.expandedHeight);
			state.currentHeight += state.stepLength;
			if(state.currentHeight >= expandedHeight) {
				state.currentHeight = expandedHeight;
				animationComplete = true;
			}
		}
		else {
			var height = parseInt(asset.height);
			var top = asset.offsetTop + "px";
			var right = asset.offsetRight + "px";
			var left = asset.offsetLeft + "px";
			state.currentHeight -= state.stepLength;
			if(state.currentHeight <= height) {
				state.currentHeight = height;
				animationComplete = true;
			}
		}

		var placeholder = this.globalTemplate.toObject("EXPANDO_PLACEHOLDER_" + assetId);
		placeholder.style.height = state.currentHeight + "px";
		var variableName = "DIV_" + assetId;
		var exp = this.globalTemplate.toObject(variableName);
		if (this.globalTemplate.usesSalignForExpanding(asset.salign, asset.wmode)) {
			exp = document.getElementById("FLASH_"+assetId);
			exp.style.width = top == "auto" ? asset.expandedWidth + "px" : asset.width + "px";
			exp.style.height = state.currentHeight + "px";
			exp.style.marginLeft = top == "auto" ? "0px" : asset.offsetLeft + "px";
			exp.style.marginTop = top == "auto" ? "0px" : asset.offsetTop + "px";
		}
		exp.style.clip = "rect(" + top + " " + right + " " + state.currentHeight + "px " + left + ")";
		if(animationComplete) {
			state.isRunning = false;
			if(this.reloadOnCollapse) {
				this.reloadFlash(assetId);
			}
		}
		else {
			window.setTimeout(state.animateCallback, state.updateInterval);
		}
	}

	function scheduleCallbackOnLoad(callback) {
		callback = "dartCreativeDisplayManagers[\"" + this.creativeIdentifier + "\"]." + callback;
		this.globalTemplate.registerPageLoadHandler(callback, null);
	}
	this.scheduleCallbackOnLoad = scheduleCallbackOnLoad;

	function scheduleDisplay(variableName, startTime, duration, adjustElements) {
		adjustElements = (adjustElements == false || adjustElements == "false") ? false : true;
		if(this.globalTemplate._isValidStartTime(startTime)) {
			startTime = eval(startTime);
			duration = this.globalTemplate._convertDuration(duration);
			this.globalTemplate.registerTimeoutHandler(startTime * 1000, "_startDisplay('" + variableName + "', " + adjustElements + ")", this);
			if(duration == "AUTO") {
				this.globalTemplate.registerTimeoutHandler((startTime + 1) * 1000, "_autoStopPlaying('" + variableName + "')", this);
			}
			else if(duration > 0) {
				duration = eval(duration);
				this.globalTemplate.registerTimeoutHandler((startTime + duration) * 1000, "stopDisplay('" + variableName + "')", this);
			}
		}
	}
	this.scheduleDisplay = scheduleDisplay;

	function getCompanionAssetName(myName, type) {
		if(typeof(type) != "undefined") {
			for(var i in this.assets) {
				if(!this.globalTemplate.isPartOfArrayPrototype(i) && this.assets[i].assetType == type)
					return i;
			}
		}
		else {
			for(var i in this.assets) {
				if(!this.globalTemplate.isPartOfArrayPrototype(i) && i != myName)
					return i;
			}
		}

		return null;
	}
	this.getCompanionAssetName = getCompanionAssetName;

	function getAsset(name) {
		return this.assets[name];
	}
	this.getAsset = getAsset;

	function tellAssetHide(assetName) {
		this.stopDisplay(assetName);
	}
	this.tellAssetHide = tellAssetHide;

	function tellAssetShow(assetName) {
		this._startDisplay(assetName)
	}
	this.tellAssetShow = tellAssetShow;

	function tellAssetStart(assetName) {
		if(this.isFlashScriptingSupported()) {
			this.playFlash(assetName);
		}
	}
	this.tellAssetStart = tellAssetStart;

	function tellAssetStop(assetName) {
		var flashObject = this.globalTemplate.toObject("FLASH_" + assetName);
		if(flashObject && this.isFlashScriptingSupported()) {
			flashObject.StopPlay();
		}
	}
	this.tellAssetStop = tellAssetStop;

	function tellAssetGotoFrame(assetName, frameNumber) {
		var flashObject = this.globalTemplate.toObject("FLASH_" + assetName);
		if(flashObject && this.isFlashScriptingSupported()) {
			flashObject.GotoFrame(frameNumber);
		}
	}
	this.tellAssetGotoFrame = tellAssetGotoFrame;

	function tellCompanionAssetStop(myName, type) {
		var companion = this.getCompanionAssetName(myName, type);
		if(companion != null) {
			this.tellAssetStop(companion);
		}
	}
	this.tellCompanionAssetStop = tellCompanionAssetStop;

	function tellCompanionAssetStart(myName, type) {
		var companion = this.getCompanionAssetName(myName, type);
		if(companion != null) {
			this.tellAssetStart(companion);
		}
	}
	this.tellCompanionAssetStart = tellCompanionAssetStart;

	function tellCompanionAssetHide(myName, type) {
		var companion = this.getCompanionAssetName(myName, type);
		if(companion != null) {
			this.stopDisplay(companion);
		}
	}
	this.tellCompanionAssetHide = tellCompanionAssetHide;

	function tellCompanionAssetShow(myName, type) {
		var companion = this.getCompanionAssetName(myName, type);
		if(companion != null) {
			var divObject = this.globalTemplate.toObject("DIV_" + companion);
			if(divObject && divObject.style.visibility != "visible") {
				var asset = this.getAsset(companion);
				if(asset != null) {
					var flashObject = this.globalTemplate.toObject("FLASH_" + companion);
					if(flashObject && this.isFlashScriptingSupported() && asset.conduitInitialized) {
						flashObject.Rewind();
						flashObject.StopPlay();
					}
					this.scheduleDisplay(companion, 0, asset.duration);

					if(asset.isMainAsset) {
						var rid = this.getRenderingId(companion);
						this.logEvent("Start", "2", rid);
					}
				}
			}
		}
	}
	this.tellCompanionAssetShow = tellCompanionAssetShow;

	function isAssetPlaying(assetName) {
		var flashObject = this.globalTemplate.toObject("FLASH_" + assetName);
		if(flashObject && this.isFlashScriptingSupported()) {
			return flashObject.IsPlaying();
		}
		return false;
	}
	this.isAssetPlaying = isAssetPlaying;

	function openPopup(url, dartWindowName, features, isPopUnder) {
		var windowRef = window.open(url, dartWindowName, features);
		this.dartPopupArray[dartWindowName] = windowRef;
		if(eval(isPopUnder)) {
			window.focus();
		}
		return windowRef;
	}
	this.openPopup = openPopup;

	function openPopupAsset(assetName) {
		this.globalTemplate.openPopupAsset(assetName);
	}
	this.openPopupAsset = openPopupAsset;

	function closePopupAsset(assetName) {
		this.globalTemplate.closePopupAsset(assetName);
	}
	this.closePopupAsset = closePopupAsset;

	function stopDisplay(variableName) {
		var divObject = this.globalTemplate.toObject("DIV_" + variableName);
		var flash = this.globalTemplate.toObject("FLASH_" + variableName);
		if(divObject && divObject.style.visibility == "visible") {
			var rid = this.getRenderingId(variableName);
			if(rid) {
				var asset = this.getAsset(variableName);
				if(asset != null && asset.isMainAsset) {
					this.stopStandardTimers(rid);
				}

				this.flushCounters(rid);
				if(!this.isAnyCompanionVisible(variableName)) {
					this.setShouldFlush(rid, false);
				}
			}
			flash.StopPlay();
			divObject.style.visibility = "hidden";
		}
		this._adjustWindowElements(variableName, false);
	}
	this.stopDisplay = stopDisplay;

	function isAnyCompanionVisible(variableName) {
		for(var i in this.assets) {
			if(!this.globalTemplate.isPartOfArrayPrototype(i) && i != variableName) {
				var divObject = this.globalTemplate.toObject("DIV_" + i);
				if(divObject && divObject.style.visibility == "visible")
					return true;
			}
		}

		return false;
	}
	this.isAnyCompanionVisible = isAnyCompanionVisible;

	function addEntityProperties(entityName, hideDropDowns, hideIFrames, hideScrollBars, hideObjects, hideApplets, adjustZIndex) {
		this.dartEntityPropertiesArray[entityName] = new _entityProperties(hideDropDowns, hideIFrames, hideScrollBars, hideObjects, hideApplets, adjustZIndex);
	}
	this.addEntityProperties = addEntityProperties;

	function doNotAdjustIFrame(variableName, iFrameID) {
		this.noAdjustElements.iFrames[this.noAdjustElements.iFrames.length] = iFrameID;
	}
	this.doNotAdjustIFrame = doNotAdjustIFrame;

	function doNotAdjustObject(variableName, objectID) {
		this.noAdjustElements.objects[this.noAdjustElements.objects.length] = objectID;
	}
	this.doNotAdjustObject = doNotAdjustObject;

	function getRenderingId(variableName) {
		var splitArray = variableName.split("_");
		var renderingId = (splitArray.length > 1) ? splitArray[0] : null;
		return renderingId;
	}
	this.getRenderingId = getRenderingId;

	function _splitArgs(args) {
		var parameterArray = new Array();
		var unescapedArgs = unescape(args)
		var stringArray = unescapedArgs.split("#mtf#");
		for(var k = 0; k < stringArray.length; k++) {
			parameterArray[k] = stringArray[k];
		}
		return parameterArray;
	}
	this._splitArgs = _splitArgs;

	function _startDisplay(variableName, adjustElements) {
		adjustElements = (adjustElements == false || adjustElements == "false") ? false : true;
		var divObject = this.globalTemplate.toObject("DIV_" + variableName);
		var flashObject = this.globalTemplate.toObject("FLASH_" + variableName);
		var asset = this.getAsset(variableName);
		if(adjustElements) {
			this._adjustWindowElements(variableName, true);
		}
		if(divObject && !this.isTzCreative) {
			divObject.style.visibility = "visible";
		}
		if(flashObject && this.isFlashScriptingSupported() && !this.isTzCreative) {
			this.playFlash(variableName);
		}

		var rid = this.getRenderingId(variableName);
		if(flashObject && this.debugEventsMode) {
			if(!this.dartDebugEventBin.getShouldFlush(rid)) {
				this.setShouldFlush(rid, true);
				this.dartDebugEventBin.flushMetCounters(rid);
			}
		}
		else {
			if(flashObject && !this.previewMode && !this.dartEventBin.getShouldFlush(rid))
				this.setShouldFlush(rid, true);
		}
	}
	this._startDisplay = _startDisplay;

	function playFlash(variableName) {
		var flashObject = this.globalTemplate.toObject("FLASH_" + variableName);
		var asset = this.getAsset(variableName);
		var type = asset.assetType;
		if(this.globalTemplate.isInternetExplorer() && flashObject.TCurrentFrame("/")<=0) {
			flashObject.Play();
		}
		else if(type=="float" || type=="reminder" || type=="banner" || type=="expando") {
			if(asset.conduitInitialized && flashObject.TCurrentFrame("/")<=0)
				flashObject.Play();
			else
				this.globalTemplate.registerTimeoutHandler(100, "playFlash('" + variableName + "')", this);
		}
	}
	this.playFlash = playFlash;

	function _autoStopPlaying(variableName) {
		var flashObject = this.globalTemplate.toObject("FLASH_" + variableName);
		if(flashObject && this.isFlashScriptingSupported()) {
			if(flashObject.PercentLoaded() == 100 && !flashObject.IsPlaying())
				this.stopDisplay(variableName);
			else
				this.globalTemplate.registerTimeoutHandler(300, "_autoStopPlaying('" + variableName + "')", this);
		}
	}
	this._autoStopPlaying = _autoStopPlaying;

	function _adjustWindowElements(entityName, shouldHide) {
		var entityProperty = this.dartEntityPropertiesArray[entityName];
		if(entityProperty) {
			if(entityProperty.hideDropDowns)
				this._adjustElements(shouldHide, "select");
			if(entityProperty.hideScrollBars && (this.globalTemplate.isInternetExplorer() || this.globalTemplate.isSafari()))
				this.browser.adjustScrollbars(shouldHide);
			if(entityProperty.hideIFrames)
				this._adjustElements(shouldHide, "iframe");
			if(entityProperty.hideObjects) {
				this._adjustElements(shouldHide, "object");
				this._adjustElements(shouldHide, "embed");
			}
			if(entityProperty.hideApplets)
				this._adjustElements(shouldHide, "applet");
			if(entityProperty.adjustZIndex)
				this._adjustZIndex(entityName, shouldHide);
		}
	}
	this._adjustWindowElements = _adjustWindowElements;

	function _adjustZIndex(entityName, shouldHide) {
		try {
			this._adjustParentZIndex(entityName, shouldHide);
		}
		catch(e) {}
	}
	this._adjustZIndex = _adjustZIndex;

	function _adjustParentZIndex(entityName, shouldHide) {
		var div = this.globalTemplate.toObject("DIV_" + entityName);
		var parent = null;
		var asset = this.getAsset(entityName);
		if(div && typeof(asset.assetType) != "undefined" && asset.assetType == "expando") {
			parent = div.parentNode.parentNode;
		}
		else {
			return;
		}

		while(parent && parent.tagName != "BODY") {
			if(shouldHide) {
				var css = this.browser.getCascadedStyle(parent);
				if((div.style.zIndex > css.zIndex) && (css.position == "relative" || css.position == "absolute")) {
					parent.style.originalZIndex = this.browser.getCascadedStyle(parent).zIndex;
					parent.style.zIndex = div.style.zIndex;
				}
			}
			else {
				if(typeof(parent.style.originalZIndex) != "undefined") {
					parent.style.zIndex = parent.style.originalZIndex;
				}
			}
			parent = parent.parentNode;
		}
	}
	this._adjustParentZIndex = _adjustParentZIndex;

	function _adjustElements(shouldHide, tagName) {
		var arr = self.document.getElementsByTagName(tagName);
		tagName = tagName.toLowerCase();
		for(var k = 0; k < arr.length; k++) {
			var adjust = true;
			if(tagName == "iframe") {
				if(typeof(arr[k].MotifIFrameID) != "undefined")
					adjust = this._shouldAdjustIFrame(arr[k].MotifIFrameID);
			}
			else if(tagName == "object" || tagName == "embed")
				adjust = !this.isMotifObject(arr[k].id);
			if(adjust)
				shouldHide ? this.hideElement(arr[k]) : this.showElement(arr[k]);
		}
	}
	this._adjustElements = _adjustElements;

	function hideElement(element) {
		var hideCountValue = element.getAttribute("hideCount");
		if(hideCountValue == null || hideCountValue == "") {
			element.setAttribute("initialVisibility", element.style.visibility);
			element.setAttribute("hideCount", 0);
		}

		var count = parseInt(element.getAttribute("hideCount"));
		if(count == 0) {
			if((element.tagName).toLowerCase() == "iframe" && this.globalTemplate.isFirefox())
				this.browser.hideFirefoxIFrame(element);
			else
				element.style.visibility = "hidden";
		}
		count++;
		element.setAttribute("hideCount", count);
	}
	this.hideElement = hideElement;

	function showElement(element) {
		if(element.getAttribute("hideCount") != null) {
			var count = parseInt(element.getAttribute("hideCount"));
			if(count != 0)
				count--;
			element.setAttribute("hideCount", count);
			if(count == 0) {
				if((element.tagName).toLowerCase() == "iframe" && this.globalTemplate.isFirefox())
					this.browser.displayFirefoxIFrame(element);
				else
					element.style.visibility = element.getAttribute("initialVisibility");
			}
		}
	}
	this.showElement = showElement;

	function _shouldAdjustIFrame(motifIFrameId) {
		var iframes = this.noAdjustElements.iFrames;
		for(var k = 0; k < iframes.length; k++) {
			if(iframes[k] == motifIFrameId)
				return false;
		}
		return true;
	}
	this._shouldAdjustIFrame = _shouldAdjustIFrame;

	this.isMotifObject = function(objectId) {
		for(var creativeIdentifier in dartCreativeDisplayManagers) {
			var manager = dartCreativeDisplayManagers[creativeIdentifier];
			if(manager != null) {
				var creative = manager.creative;
				if(creative != null) {
					for(var type in creative.assets) {
						if(objectId == "FLASH_" + creative.assets[type].variableName)
						return true;
					}
				}
			}
		}
		return false;
	}

	function _entityProperties(hideDropDowns, hideIFrames, hideScrollBars, hideObjects, hideApplets, adjustZIndex) {
		this.hideDropDowns = hideDropDowns;
		this.hideIFrames = hideIFrames;
		this.hideScrollBars = hideScrollBars;
		this.hideObjects = hideObjects;
		this.hideApplets = hideApplets;
		this.adjustZIndex = adjustZIndex;
	}

	function _doNotAdjustElement() {
		this.iFrames = new Array();
		this.objects = new Array();
	}

	function getPercentPosition(assetPos, adLength, screenLength) {
		assetPos = this.extractLength(assetPos);
		adLength = parseInt(adLength);
		return (screenLength - adLength) * assetPos/100;
	}
	this.getPercentPosition = getPercentPosition;

	this.extractUnit = function(pos) {
		if(pos.indexOf("%") > -1)
			return "%";
		else if(pos.indexOf("pxc") > -1)
			return "pxc";
		else
			return "px";
	}

	function extractLength(pos) {
		if(pos.indexOf("%") > -1)
			return parseInt(pos.substring(0, pos.indexOf("%")));
		else if(pos.indexOf("px") > -1)
			return parseInt(pos.substring(0, pos.indexOf("px")));
		else
			return parseInt(pos);
	}
	this.extractLength = extractLength;


	//only works for relative body element with margins set to auto (centering)
	function getBodyLeft() {
		var left;
		var position;

		if (this.globalTemplate.isInternetExplorer()) {
			left = this.extractLength(document.body.currentStyle.left);
			position = document.body.currentStyle.position;
		}
		else{
			var style=window.getComputedStyle(document.body, "");
			left = this.extractLength(style.getPropertyValue("left"));
			position = style.getPropertyValue("position");
		}

		if (position == "relative") {
			left = (this.browser.getWindowDimension().width-document.body.clientWidth)*.5;
		}

		return (isNaN(parseInt(left)) || left <1)?0:left;
	}
	this.getBodyLeft = getBodyLeft;


	this.adjustAdDiv = function(adDiv, asset) {
		var left = this.extractLength(asset.left);
		var top = this.extractLength(asset.top);
		var dimension = this.browser.getWindowDimension();
		var scroll = this.browser.getScrollbarPosition();
		var leftUnit = this.extractUnit(asset.left);
		if(leftUnit == "%")
			left = this.getPercentPosition(asset.left, asset.width, dimension.width);
		else if(leftUnit == "pxc")
			left = left + dimension.width/2;
		if(this.extractUnit(asset.top) == "%")
			top = this.getPercentPosition(asset.top, asset.height, dimension.height);
		if(asset.ignoreHorizontalScroll)
			left = left + scroll.scrollLeft;
		if(asset.ignoreVerticalScroll)
			top = top + scroll.scrollTop;

		if(typeof(asset.isRelativeBody) == "boolean" && asset.isRelativeBody) {
			left -= this.getBodyLeft();
		}

		adDiv.style.left = left + "px";
		adDiv.style.top = top + "px";
	}

	function adjustPosition() {
		for(var varName in this.assets) {
			if(!this.globalTemplate.isPartOfArrayPrototype(varName)) {
				var asset = this.getAsset(varName);
				if(asset.assetType == "float" || asset.assetType == "reminder") {
					var adDiv = this.globalTemplate.toObject("DIV_" + varName);
					if(adDiv != null)
						this.adjustAdDiv(adDiv, asset);
				}
			}
		}
	}
	this.adjustPosition = adjustPosition;

	function registerPercentPositioningHandler() {
		var isPercentPositioned = false;
		var ignoreScroll = false;
		var centerPositioned = false;
		for(var name in this.assets) {
			if(!this.globalTemplate.isPartOfArrayPrototype(name)) {
				var asset = this.getAsset(name);
				if(asset.assetType == "float" || asset.assetType == "reminder") {
					if(this.extractUnit(asset.top) == "%" || this.extractUnit(asset.left) == "%")
						isPercentPositioned = true;
					if(asset.ignoreVerticalScroll || asset.ignoreHorizontalScroll)
						ignoreScroll = true;
					if(this.extractUnit(asset.left) == "pxc")
						centerPositioned = true;
				}
			}
		}
		if(isPercentPositioned || ignoreScroll || centerPositioned)
			this.globalTemplate.registerEventHandler("resize", self, "adjustPosition()", this);
		if(ignoreScroll)
			this.globalTemplate.registerEventHandler("scroll", self, "adjustPosition()", this);
	}
	this.registerPercentPositioningHandler = registerPercentPositioningHandler;

	function getFloatingDiv(fl, interstitialImage) {
		var adDiv = document.createElement("DIV");
		adDiv.id = "DIV_" + fl.variableName;
		adDiv.style.position = fl.position;
		adDiv.style.visibility = this.globalTemplate.getFlashVisibility();
		adDiv.style.zIndex = fl.zIndex;
		this.adjustAdDiv(adDiv, fl);
		var movie = fl.url;
		var queryString=fl.queryString + '&td=' + escape(self.location.hostname);
		var loop = (this.globalTemplate._convertDuration(fl.duration) == "AUTO") ? "false" : "true";
		adDiv.innerHTML = this.globalTemplate.getObjectHtml("id", "FLASH_" + fl.variableName, "name", "FLASH_" + fl.variableName,
							"WIDTH", fl.width, "HEIGHT", fl.height, "movie", movie, "play", "false",
							"quality", "high", "wmode", fl.wmode, "loop", loop,
							"queryString",queryString
							);
		if(interstitialImage != "") {
			var imgDiv = document.createElement("DIV");
			imgDiv.style.position = "absolute";
			imgDiv.style.top = "0px";
			imgDiv.style.left = "0px";
			imgDiv.innerHTML = ' <img src="' + interstitialImage + '" style="visibility:hidden" width="1px" height="1px">';
			adDiv.appendChild(imgDiv);
		}
		this.doNotAdjustObject(fl.variableName, "FLASH_" + fl.variableName);
		return adDiv;
	}
	this.getFloatingDiv = getFloatingDiv;

	this.displayFloatingAsset = function(fl, interstitialImage) {
		try {
			var adDiv = this.getFloatingDiv(fl, interstitialImage);
			this.registerCreativeElement(adDiv);
			document.body.appendChild(adDiv);
			this.fsHook("FLASH_" + fl.variableName);
			this.addEntityProperties(fl.variableName, fl.hideDropdowns, fl.hideIframes, fl.hideScrollbars, fl.hideObjects, fl.hideApplets, false);
			if(this.globalTemplate.isTzCreative)
				var startTime = "0";
			else
				var startTime = fl.startTime;
			this.scheduleDisplay(fl.variableName, startTime, fl.duration);
			this.registerUrl(this.renderingId, fl.adserverUrl, startTime);
		}
		catch(e) {}
	}

	this.displayFloatingFlash = function() {
		var fl = this.creative.assets["FloatingFlash"];
		this.displayFloatingAsset(fl, fl.interstitialImage);
		this.registerPercentPositioningHandler();
	}

	this.displayFloatingWithReminder = function() {
		var fl = this.creative.assets["FloatingFlash"];
		this.displayFloatingAsset(fl, fl.interstitialImage);
		var rem = this.creative.assets["ReminderFlash"];
		this.displayFloatingAsset(rem, "");
		this.registerPercentPositioningHandler();
	}

	function triggerPoliteDownload() {
		for(assetName in this.assets) {
			if(!this.globalTemplate.isPartOfArrayPrototype(assetName)) {
				this.finishPoliteDownload(assetName);
			}
		}
	}
	this.triggerPoliteDownload = triggerPoliteDownload;

	function finishPoliteDownload(assetName) {
		var flashObject = this.globalTemplate.toObject("FLASH_" + assetName);
		if(flashObject && typeof(flashObject.PercentLoaded) != "undefined" && flashObject.PercentLoaded() > 0 && this.getAsset(assetName).conduitInitialized) {
			flashObject.SetVariable("_root.mtfContinue", "1");
		}
		else {
			var callback = "finishPoliteDownload('" + assetName + "')";
			this.globalTemplate.registerTimeoutHandler(100, callback, this);
		}
	}
	this.finishPoliteDownload = finishPoliteDownload;
    
    function triggerDispatchScriptLoaded() {
        for(assetName in this.assets) {
            if(!this.globalTemplate.isPartOfArrayPrototype(assetName)) {
                this.finishDispatchScriptLoaded(assetName);
            }
        }
    }
    this.triggerDispatchScriptLoaded = triggerDispatchScriptLoaded;
    
    function finishDispatchScriptLoaded(assetName) {
        var flashObject = this.globalTemplate.toObject("FLASH_" + assetName);
        if(flashObject && typeof(flashObject.PercentLoaded) != "undefined" && flashObject.PercentLoaded() > 0 &&  typeof(flashObject.TCurrentFrame) != "undefined" && flashObject.TCurrentFrame("/")>=0) {
            flashObject.SetVariable("_root.globalTemplateScriptLoaded", "1");
        } else {
            var callback = "finishDispatchScriptLoaded('" + assetName + "')";
            this.globalTemplate.registerTimeoutHandler(100, callback, this);
        }
    }
    this.finishDispatchScriptLoaded = finishDispatchScriptLoaded;

	function closeSelfPopup() {
		if (typeof(dartIsOverlay) != "undefined" && dartIsOverlay) parent.dartGlobalTemplateObjects[dartCreativeIdentifier].closePopupAsset(dartInpageAssetID);
		else window.open("javascript:window.close();",'_self');

	}
	this.closeSelfPopup = closeSelfPopup;

	function unloadPopup() {
		var rid = this.renderingId;
		if(rid) {
			this.flushCounters(rid);
			this.setShouldFlush(rid, false);
			this.stopStandardTimers(rid);
		}
	}
	this.unloadPopup = unloadPopup;

	function forceAnimation(variableName) {
		var flash = this.globalTemplate.toObject("FLASH_" + variableName);
		var div = this.globalTemplate.toObject("DIV_" + variableName);
		if(div.style.visibility == "visible") {
			flash.Zoom(50);
			flash.Zoom(0);
		}
	}
	this.forceAnimation = forceAnimation;

	function launchFullScreenVideo(url, shouldTrack, isMute) {
		var fsvManager = dartFSVManagers["FSV_" + this.globalTemplate.creativeIdentifier];
		fsvManager.launchVideo(url, eval(shouldTrack), isMute);
	}
	this.launchFullScreenVideo = launchFullScreenVideo;

	function isFlashScriptingSupported() {
		return (this.globalTemplate.isWindows() || (this.globalTemplate.isMac() && (this.globalTemplate.isFirefox() || this.globalTemplate.isSafari())));
	}
	this.isFlashScriptingSupported = isFlashScriptingSupported;

	this.registerCreativeElement = function(rootElement) {
		this.rootElementArray[this.rootElementArray.length] = rootElement;
}

	this.removeChildNode = function(nodeElement,rootElementParent) {
		if(nodeElement.hasChildNodes()) {
			var childNodeList = nodeElement.childNodes;
			for(var k = 0; k < childNodeList.length; k++) {
				this.removeChildNode(childNodeList[k], rootElementParent);
			}
		}
		else {
			var parentOfChildNode = nodeElement.parentNode;
			parentOfChildNode.removeChild(nodeElement);
			if(rootElementParent != parentOfChildNode)
				this.removeChildNode(parentOfChildNode, rootElementParent);
		}
	}

}  // end of DARTCreativeDisplayManager_XX


function DARTBrowser_20_21(globalTemplate) {
	this.iframePlaceHolderDivIndex = 0;
	this.hiddenIframes = new Array();
	this.globalTemplate = globalTemplate;

	function hideFirefoxIFrame(iframe) {
		var div = null;
		var iframeInfo = null;
		if(!iframe.hasAttribute("Motif_IFramePlaceHolderDivIndex")) {
			div = document.createElement("DIV");
			div.id = "MOTIF_IFRAMEPLACEHOLDER_" + this.iframePlaceHolderDivIndex;
			div.style.width = "0px";
			div.style.height = "0px";
			div.style.visibility = "hidden";
			div.style.padding = "0px";
			div.style.margin = "0px";
			div.style.display = "inline";
			iframe.parentNode.insertBefore(div, iframe);
			div.innerHTML = '<img src="" width="0px" height="0px" padding="0px" margin="0px"></img>';
			iframe.setAttribute("Motif_IFramePlaceHolderDivIndex", this.iframePlaceHolderDivIndex);
			iframeInfo = new Object();
			this.hiddenIframes[this.iframePlaceHolderDivIndex] = iframeInfo;
			this.iframePlaceHolderDivIndex++;
		}
		else {
			var index = iframe.getAttribute("Motif_IFramePlaceHolderDivIndex");
			var id = "MOTIF_IFRAMEPLACEHOLDER_" + index;
			div = document.getElementById(id);
			iframeInfo = this.hiddenIframes[parseInt(index)];
		}
		iframeInfo.width = iframe.width;
		iframeInfo.height = iframe.height;
		div.style.width = iframeInfo.width;
		div.style.height = iframeInfo.height;
		div.firstChild.width = iframeInfo.width;
		div.firstChild.height = iframeInfo.height;
		iframe.style.visibility = "hidden";
		iframe.width = 0;
		iframe.height = 0;
	}
	this.hideFirefoxIFrame = hideFirefoxIFrame;

	function displayFirefoxIFrame(iframe) {
		var index = iframe.getAttribute("Motif_IFramePlaceHolderDivIndex");
		var id = "MOTIF_IFRAMEPLACEHOLDER_" + index;
		var div = document.getElementById(id);
		var iframeInfo = this.hiddenIframes[parseInt(index)];
		if(div != null) {
			iframe.width = iframeInfo.width;
			iframe.height = iframeInfo.height;
			div.style.width = "0px";
			div.style.height = "0px";
			div.firstChild.width = 0;
			div.firstChild.height = 0;
		}
		iframe.style.visibility = iframe.getAttribute("initialVisibility");
	}
	this.displayFirefoxIFrame = displayFirefoxIFrame;

	function adjustScrollbars(hide) {
		var doc = self.document.documentElement;
		var standardCSSMode = ((typeof(document.compatMode) != "undefined" && document.compatMode == "CSS1Compat") ? true : false);
		standardCSSMode |= this.globalTemplate.isSafari();
		if(hide) {
			if(standardCSSMode) {
				doc.style.originalOverflow = typeof(doc.currentStyle) == "object" ? doc.currentStyle.overflow : doc.style.overflow;
				doc.style.overflow = "hidden";
			}
			else
				self.document.body.scroll = "no";
		}
		else {
			if(standardCSSMode) {
				if(typeof(doc.style.originalOverflow) != "undefined") {
					doc.style.overflow = doc.style.originalOverflow;
				}
			}
			else
				self.document.body.scroll = "yes";
		}
	}
	this.adjustScrollbars = adjustScrollbars;

	function getCascadedStyle(obj) {
		if(this.globalTemplate.isInternetExplorer())
			return obj.currentStyle;
		else
			return obj.style;
	}
	this.getCascadedStyle = getCascadedStyle;

	this.getComputedStyle = function(ele) {
		if(this.globalTemplate.isInternetExplorer())
			return ele.currentStyle;
		else if(this.globalTemplate.isFirefox() && typeof(window.getComputedStyle) != "undefined")
			return window.getComputedStyle(ele, "");
		else
			return ele.style;
	}

	this.getWindowDimension = function() {
		var dimension = new Object();
		if(document.documentElement && document.compatMode == "CSS1Compat") {
			dimension.width = document.documentElement.clientWidth;
			dimension.height = document.documentElement.clientHeight;
		} else if(document.body && (document.body.clientWidth || document.body.clientHeight) && !this.globalTemplate.isSafari()) {
			dimension.width = document.body.clientWidth;
			dimension.height = document.body.clientHeight;
		} else if(typeof(window.innerWidth) == 'number') {
			dimension.width = window.innerWidth;
			dimension.height = window.innerHeight;
		}
		return dimension;
	}

	this.getScrollbarPosition = function() {
		var scrollPos = new Object();
		scrollPos.scrollTop = 0;
		scrollPos.scrollLeft = 0;
		if(typeof(window.pageYOffset) == 'number') {
			scrollPos.scrollTop = window.pageYOffset;
			scrollPos.scrollLeft = window.pageXOffset;
		} else if(document.body && (document.body.scrollLeft || document.body.scrollTop)) {
			scrollPos.scrollTop = document.body.scrollTop;
			scrollPos.scrollLeft = document.body.scrollLeft;
		} else if(document.documentElement && (document.documentElement.scrollLeft || document.documentElement.scrollTop)) {
			scrollPos.scrollTop = document.documentElement.scrollTop;
			scrollPos.scrollLeft = document.documentElement.scrollLeft;
		}
		return scrollPos;
	}

}  // end of DARTBrowser_XX




function DARTEventBin_20_21(creativeIdentifier, globalTemplate, mtfNoFlush) {
	this.dartIntervalArray = mtfNoFlush ? new Array() : new Array(10, 20, 50, 120, 240);
	this.dartEventBinCollection = new Array();
	this.dartRegistrationTime = null;
	this.dartMaxTimeMilliseconds = (20 * 60 * 1000);
	this.dartCreativeIdentifier = creativeIdentifier;
	this.dartGlobalTemplate = globalTemplate;


	function registerEventBinUrl(erid, adServerUrl, startTime) {
		if(!this.dartEventBinCollection[erid] && this.dartGlobalTemplate._isValidStartTime(startTime)) {
			startTime = (startTime) ? eval(startTime) : 0;
			var eventBin = new Array();
			eventBin["counter"]  = new Array();
			eventBin["timer"]    = new Array();
			eventBin["duration"] = new Array();
			eventBin["nonCumulativeCounters"] = new Array();
			eventBin["flushUrl"] = adServerUrl;
			eventBin["shouldFlush"] = true;
			this.dartEventBinCollection[erid] = eventBin;
			this.dartRegistrationTime = new Date();
			this.dartGlobalTemplate.registerTimeoutHandler(startTime * 1000, "setFlushInterval('" + erid + "')", this);
		}
	}
	this.registerEventBinUrl = registerEventBinUrl;

	function logMetEvent(eventType, eventId, erid, isCumulative) {
		if(this.dartEventBinCollection[erid] && eventId && !isNaN(eventId)) {
			switch(eventType)   {
				case "Count": {
					this.processCounter(eventId, erid, isCumulative);
					break;
				}
				case "Start": {
					this.processStart(eventId, erid);
					break;
				}
				case "Stop": {
					this.processStopTimer(eventId, erid);
					break;
				}
				default : break;
			}
		}
	}
	this.logMetEvent = logMetEvent;

	function processCounter(eventId, erid, isCumulative) {
		var nonCumulativeCounters = this.getNonCumulativeCountersArray(erid);
		var counterArray = this.getCounterArray(erid);
		isCumulative = (isCumulative && (isCumulative == "true" || isCumulative == true)) ? true : false;
		if(isCumulative == false) {
			if(!nonCumulativeCounters[eventId])
			   counterArray[eventId] = 1;
			nonCumulativeCounters[eventId] = true;
		}
		else {
			if(!counterArray[eventId])
			   counterArray[eventId] = 0;
			counterArray[eventId] = counterArray[eventId]+1;
		}
	}
	this.processCounter = processCounter;

	function processStart(eventId, erid) {
		var timerArray = this.getTimerArray(erid);
		if(!timerArray[eventId]) {
			timerArray[eventId] = new Date();
			this.processCounter(eventId, erid, false);
		}
	}
	this.processStart = processStart;

	function processStopTimer(eventId, erid) {
		var timerArray = this.getTimerArray(erid);
		var durationArray = this.getDurationArray(erid);
		if(timerArray[eventId]) {
			var start = timerArray[eventId];
			var end = new Date();
			var duration = end.getTime() - start.getTime();
			if(duration < 0 || duration > this.dartMaxTimeMilliseconds)
				duration = 0;
			durationArray[eventId] = durationArray[eventId] ? durationArray[eventId] + duration : duration;
			timerArray[eventId] = false;
			return true;
		}
		return false;
	}
	this.processStopTimer = processStopTimer;

	function flushMetCounters(erid) {
		if(this.dartEventBinCollection[erid] && this.getShouldFlush(erid)) {
			var activityUrl = "";
			var counterArray = this.getCounterArray(erid);
			var durationArray = this.getDurationArray(erid);
			var timerArray = this.getTimerArray(erid);
			var counter = 1;
			if(this.isInAllowedTimeframe()) {
				for(var eventId in counterArray) {
					if(!this.dartGlobalTemplate.isPartOfArrayPrototype(eventId)) {
						var wasStopped = this.processStopTimer(eventId, erid);
						var counterValue = counterArray[eventId];
						if(!durationArray[eventId])
							durationArray[eventId] = 0;
						var durationValue = this.roundNumber((durationArray[eventId] ? parseFloat(String(durationArray[eventId] / 1000)) : 0));
						if(counterValue > 0 || durationValue > 0) {
							activityUrl += "eid" + counter + "=" + eventId + ";";
							activityUrl += "ecn" + counter + "=" + counterValue + ";";
							activityUrl += "etm" + counter + "=" + durationValue + ";";
						}
						counterArray[eventId] = counterArray[eventId] - counterValue;
						durationArray[eventId] = durationArray[eventId] - durationValue * 1000;
						if(wasStopped) {
							timerArray[eventId] = new Date();
						}
						counter++;
					}
				}
				this.postData(activityUrl, erid);
			}
		}
	}
	this.flushMetCounters = flushMetCounters;

	function postData(activityUrl, erid) {
		if(activityUrl.length) {
			var timeStamp = new Date();
			var activityArray = this.splitActivity(activityUrl);
			for(var k = 0; k < activityArray.length; k++) {
				var postImage = document.createElement("IMG");
				var singleActivityString = activityArray[k];
				var postUrl = this.getFlushUrl(erid) + "&timestamp=" + timeStamp.getTime() + ";" + singleActivityString;
				postImage.src = postUrl;
			}
		}
	}
	this.postData = postData;

	function splitActivity(activity) {
		var activityArray = new Array();
		for(var key = "etm", postSize = 950, index = 0; activity.length > 0; activity = activity.substr(index)) {
			var copy = activity;
			var startString = copy.substr(0, postSize);
			index = startString.lastIndexOf(key) + key.length;
			startString = copy.substr(0, index);
			copy = copy.substr(index);
			index += copy.indexOf(";")+1;
			activityArray[activityArray.length] = activity.substr(0, index);
		}
		return activityArray;
	}
	this.splitActivity = splitActivity;

	function getCounterArray(erid) {
		var eventBin = this.dartEventBinCollection[erid];
		return eventBin["counter"];
	}
	this.getCounterArray = getCounterArray;

	function getTimerArray(erid) {
		var eventBin = this.dartEventBinCollection[erid];
		return eventBin["timer"];
	}
	this.getTimerArray = getTimerArray;

	function getDurationArray(erid) {
		var eventBin = this.dartEventBinCollection[erid];
		return eventBin["duration"];
	}
	this.getDurationArray = getDurationArray;

	function getNonCumulativeCountersArray(erid) {
		var eventBin = this.dartEventBinCollection[erid];
		return eventBin["nonCumulativeCounters"];
	}
	this.getNonCumulativeCountersArray = getNonCumulativeCountersArray;

	function getFlushUrl(erid) {
		var eventBin = this.dartEventBinCollection[erid];
		return eventBin["flushUrl"];
	}
	this.getFlushUrl = getFlushUrl;

	function getShouldFlush(erid) {
		var eventBin = this.dartEventBinCollection[erid];
		return eventBin["shouldFlush"];
	}
	this.getShouldFlush = getShouldFlush;

	function setMetShouldFlush(erid, flag) {
		var eventBin = this.dartEventBinCollection[erid];
		if(eventBin)
			eventBin["shouldFlush"] = flag;
	}
	this.setMetShouldFlush = setMetShouldFlush;

	function isInAllowedTimeframe() {
		var now = new Date();
		if(now.getTime() - this.dartRegistrationTime.getTime() > this.dartMaxTimeMilliseconds)
			return false;
		return true;
	}
	this.isInAllowedTimeframe = isInAllowedTimeframe;

	function roundNumber(number, X) {
		X = (X ? X : 0);
		return (Math.round(number*Math.pow(10,X))/Math.pow(10,X));
	}
	this.roundNumber = roundNumber;

	function setFlushInterval(erid) {
		for(var k = 0; k < this.dartIntervalArray.length; k++) {
			var timeout = (this.dartIntervalArray[k] * 1000);
			this.dartGlobalTemplate.registerTimeoutHandler(timeout, "flushMetCounters('" + erid + "')", this);
		}
	}
	this.setFlushInterval = setFlushInterval;

}  // end of DARTEventBin_XX



function FullScreenVideoManager_20_21(displayManager, fsvCreativeIdentifier) {
	this.displayManager = displayManager;
	this.globalTemplate = displayManager.globalTemplate;
	this.fsvCreativeIdentifier = fsvCreativeIdentifier;
	this.wmpPlayer = null;
	this.videoDiv = null;
	this.intervalId = null;
	this.isBufferingDone = false;
	this.isWMVStart = false;
	this.shouldTrack = true;
	this.isWideScreen = (screen.width/screen.height)>(4/3);
	this.scrHeight = screen.height;
	this.scrWidth = this.isWideScreen ? ((2/3)*this.scrHeight+(1/2)*screen.width) : screen.width;
	this.btnWidth = this.scrWidth * 0.056;
	this.topBorder = this.scrHeight * .8875;
	this.muteLeft = this.scrWidth * 0.766;
	this.playLeft = this.scrWidth * .825;
	this.pauseLeft = this.scrWidth * .884;
	this.closeLeft = this.scrWidth * .944;
	this.rootElementFSV = null;
	this.eventHandlers = new Array();

	function createFSVPlayer() {
		var wmpObjectName = "OBJECT_" + this.fsvCreativeIdentifier;
		var divVideoName = "DIV_" + this.fsvCreativeIdentifier;

		var obj = '<object id="' + wmpObjectName + '" CLASSID="CLSID:6BF52A52-394A-11D3-B153-00C04F79FAA6"';
		obj += 'TYPE="application/x-oleobject" width="0" height="0">';
		obj += '<param name="AutoStart" value="false">';
		obj += '<param name="uiMode" value="none">';
		obj += '<param name="fullScreen" value="false">';
		obj += '<param name="enableErrorDialogs" value="false">';
		obj += '</object>';

		var vidDiv = document.createElement("DIV");
		vidDiv.style.visibility = "hidden";
		vidDiv.id = divVideoName;
		vidDiv.align = "left";
		vidDiv.innerHTML = obj;
		this.rootElementFSV = vidDiv;
		window.document.body.appendChild(vidDiv);

		this.wmpPlayer = this.globalTemplate.toObject("OBJECT_" + this.fsvCreativeIdentifier);
		this.videoDiv = this.globalTemplate.toObject("DIV_" + this.fsvCreativeIdentifier);

		this.eventHandlers["PlayStateChange"] = new Function("newState", "dartFSVManagers['" + this.fsvCreativeIdentifier + "'].onPlayStateChange(newState);");
		this.eventHandlers["KeyDown"] = new Function("keyCode", "shiftState", "dartFSVManagers['" + this.fsvCreativeIdentifier + "'].onKeyDown(keyCode, shiftState);");
		this.eventHandlers["MouseDown"] = new Function("nButton", "shiftState", "fX", "fY", "dartFSVManagers['" + this.fsvCreativeIdentifier + "'].onMouseDown(nButton, shiftState, fX, fY);");
		this.eventHandlers["DoubleClick"] = new Function("nButton", "shiftState", "fX", "fY", "dartFSVManagers['" + this.fsvCreativeIdentifier + "'].onDoubleClick(nButton, shiftState, fX, fY);");

		this.wmpPlayer.attachEvent("PlayStateChange", this.eventHandlers["PlayStateChange"]);
		this.wmpPlayer.attachEvent("KeyDown", this.eventHandlers["KeyDown"]);
		this.wmpPlayer.attachEvent("MouseDown", this.eventHandlers["MouseDown"]);
		this.wmpPlayer.attachEvent("DoubleClick", this.eventHandlers["DoubleClick"]);
	}
	this.createFSVPlayer = createFSVPlayer;

	function launchVideo(url, shouldTrack, isMute) {
		this.shouldTrack = shouldTrack;
		this.wmpPlayer.URL = url;
		this.isBufferingDone = false;
		this.isWMVStart = false;
		this.wmpPlayer.controls.play();
		this.videoDiv.style.visibility = "visible";
		this.wmpPlayer.settings.mute = isMute;
		this.intervalId = setInterval('dartFSVManagers["' + this.fsvCreativeIdentifier + '"].monitorPlayer();', 100);
	}
	this.launchVideo = launchVideo;


	function hideVideoPlayer() {
		this.videoDiv.style.visibility = "hidden";
		this.wmpPlayer.controls.stop();
		this.wmpPlayer.fullscreen;
		clearInterval(this.intervalId);
		this.logFSVEvent("Stop", 7);
		this.flushFSVCounters();
	}
	this.hideVideoPlayer = hideVideoPlayer;

	function logFSVEvent(eventType, eventId) {
		if(this.shouldTrack) {
			this.displayManager.logEvent(eventType, eventId, this.displayManager.renderingId);
		}
	}
	this.logFSVEvent = logFSVEvent;


	function flushFSVCounters() {
		if(this.shouldTrack) {
			var shouldFlash = this.displayManager.getShouldFlush(this.displayManager.renderingId);
			this.displayManager.setShouldFlush(this.displayManager.renderingId, true);
			this.displayManager.flushCounters(this.displayManager.renderingId);
			this.displayManager.setShouldFlush(this.displayManager.renderingId, shouldFlash);
		}
	}
	this.flushFSVCounters = flushFSVCounters;

	function isWMV() {
		var regMatch = this.wmpPlayer.URL.toLowerCase().match(/.*\.(wmv|asf)[\s]*$/);
		return regMatch ? true: false;
	}
	this.isWMV = isWMV;

	function playFSV() {
		if(this.isBufferingDone == false) {
			this.logFSVEvent("Count", 5);
			this.hideProgressBar();
		}
		this.logFSVEvent("Start", 7);
		this.wmpPlayer.fullscreen = true;
		this.isBufferingDone = true;
	}
	this.playFSV = playFSV;

	function onPlayStateChange(newState) {
		try {
			if(newState == 3) {   // play
				if(this.isWMV()) {
					if(this.isWMVStart == false) {
						this.isWMVStart = true;
					}
					else {
						this.playFSV();
					}
				}
				else {
					this.playFSV();
				}
			}
			else if(newState == 2) {  // pause
				this.logFSVEvent("Stop", 7);
			}
		} catch(exception) {}
	}
	this.onPlayStateChange = onPlayStateChange;

	function onKeyDown(nKeyCode, nShiftState) {
		if (nKeyCode == 27) {   // escape
			this.hideVideoPlayer();
		}
	}
	this.onKeyDown = onKeyDown;

	function monitorPlayer() {
		if(this.checkFSVError()) {
			return;
		}

		if(this.wmpPlayer.currentMedia && this.wmpPlayer.controls.currentPosition) {
			if(!this.isBufferingDone && this.wmpPlayer.controls.currentPosition > 0) {
				this.playFSV();
			}
			if(this.isBufferingDone && this.wmpPlayer.controls.currentPosition > 0 && !this.wmpPlayer.fullScreen) {
				this.hideVideoPlayer();
				return;
			}
			var totalLength = this.wmpPlayer.currentMedia.duration;
			var currentPosition = this.wmpPlayer.controls.currentPosition;
			var diff = totalLength - currentPosition;

			if(diff < 0.2) {
				this.logFSVEvent("Count", 6);
				this.hideVideoPlayer();
			}
		}
	}
	this.monitorPlayer = monitorPlayer;

	function onDoubleClick(nButton, nShiftState, fX, fY) {
		this.hideVideoPlayer();
	}
	this.onDoubleClick = onDoubleClick;

	function onMouseDown(nButton, nShiftState, fX, fY) {
		// the value of "1" for nButton is the value for the left mouse click
		if ((nButton == 1) && (fY > this.topBorder)) {
			// if mute button is clicked
			if((fX > this.muteLeft) && (fX < (this.muteLeft+this.btnWidth))) {
				this.wmpPlayer.settings.mute = !(this.wmpPlayer.settings.mute);
			}
			// if play button is clicked
			if ((fX > this.playLeft) && (fX < (this.playLeft+this.btnWidth))) {
				this.wmpPlayer.controls.play();
			}
			// if pause button is clicked
			if ((fX > this.pauseLeft) && (fX < (this.pauseLeft+this.btnWidth))) {
				if(this.wmpPlayer.playState == 2) {
					this.wmpPlayer.controls.play();
				}
				else {
					this.wmpPlayer.controls.pause();
				}
			}
			// if close button is clicked
			if ((fX > this.closeLeft) && (fX < (this.closeLeft+this.btnWidth))) {
				this.hideVideoPlayer();
			}
		}
	}
	this.onMouseDown = onMouseDown;

	function checkFSVError() {
		var err = this.wmpPlayer.error;
		if(err.errorCount > 0) {
			this.hideVideoPlayer();
			err.clearErrorQueue();
			this.hideProgressBar();
			return true;
		}
		return false;
	}
	this.checkFSVError = checkFSVError;


	function hideProgressBar() {
		for(assetName in this.displayManager.assets) {
			if(!this.globalTemplate.isPartOfArrayPrototype(assetName)) {
				var flashObject = this.globalTemplate.toObject("FLASH_" + assetName);
				if(flashObject) {
					flashObject.SetVariable("_root.g_isVideoBufferComplete", "true");
				}
			}
		}
	}
	this.hideProgressBar = hideProgressBar;


	this.deleteFSVCreative = function() {
		if(this.rootElementFSV != null) {
			this.wmpPlayer.detachEvent("PlayStateChange", this.eventHandlers["PlayStateChange"]);
			this.wmpPlayer.detachEvent("KeyDown", this.eventHandlers["KeyDown"]);
			this.wmpPlayer.detachEvent("MouseDown", this.eventHandlers["MouseDown"]);
			this.wmpPlayer.detachEvent("DoubleClick", this.eventHandlers["DoubleClick"]);
			this.displayManager.removeChildNode(this.rootElementFSV, this.rootElementFSV.parentNode);
		}
	}

}   // end of FullScreenVideoManager_XX





function MotifCreativeDisplayScheduler_20_21() {
	this.gtVersion = "20_21";
	function getDisplayManager(creative) {
		var manager = new DARTCreativeDisplayManager_20_21(creative);
		dartCreativeDisplayManagers[creative.creativeIdentifier] = manager;
		return manager;
	}
	this.getDisplayManager = getDisplayManager;

	function getFullScreenManager(displayManager) {
		var fsvCreativeIdentifier = "FSV_" + displayManager.globalTemplate.creativeIdentifier;
		var manager = new FullScreenVideoManager_20_21(displayManager, fsvCreativeIdentifier);
		dartFSVManagers[fsvCreativeIdentifier] = manager;
		return manager;
	}
	this.getFullScreenManager = getFullScreenManager;

	this.displayCreative = function(creative, mgr) {
		var type = creative.type;
		var globalTemplate = dartGlobalTemplateObjects[creative.creativeIdentifier];
		var fsvManager = (creative.isFSV) ? getFullScreenManager(mgr) : null;

		if(creative.isFSV) {
			fsvManager.createFSVPlayer();
		}

		if(type == "FloatingFlash") {
			var fl = creative.assets["FloatingFlash"];
			if(globalTemplate.isTzCreative)
				globalTemplate.registerTimeoutHandler(eval(fl.startTime) * 1000, "displayFloatingFlash()", mgr);
			else
				mgr.displayFloatingFlash();
		}
		else if(type == "Pop") {
			var pop = creative.assets["PopFlash"];
			mgr.fsHook("FLASH_" + pop.variableName);
			mgr.registerUrl(creative.renderingId, pop.adserverUrl, 0);
			mgr.scheduleDisplay(pop.variableName, 0, "none");
			var duration = globalTemplate._convertDuration(pop.duration);
			if(typeof(duration) == "number" && duration > 0) {
				globalTemplate.registerTimeoutHandler(duration * 1000, "closeSelfPopup()", mgr);
			}
		}
		else if(type == "ExpandingFlash") {
			var exp = creative.assets["ExpandingFlash"];
			mgr.doNotAdjustIFrame(exp.variableName, exp.placeholderIframe);
			mgr.doNotAdjustObject(exp.variableName, "FLASH_" + exp.variableName);
			mgr.fsHook("FLASH_" + exp.variableName);
			mgr.registerUrl(creative.renderingId, exp.adserverUrl, exp.startTime);
			mgr.addEntityProperties(exp.variableName, exp.hideDropdowns, exp.hideIframes, exp.hideScrollbars, exp.hideObjects, exp.hideApplets, true);
			mgr.scheduleDisplay(exp.variableName, exp.startTime, exp.duration, false);
			mgr.collapseAsset(exp.variableName);
		}
		else if(type == "FloatingFlashReminderFlash") {
			mgr.displayFloatingWithReminder();
		}
		if(mgr.isFlashScriptingSupported()) {
			mgr.scheduleCallbackOnLoad("triggerPoliteDownload()");
            mgr.triggerDispatchScriptLoaded();
        }
	}
} // end of MotifCreativeDisplayScheduler_XX



function DARTGlobalTemplate_20_21(creativeIdentifier) {
	this.creativeIdentifier = creativeIdentifier;
	this.isTzCreative = false;
	this.tzAutoContract = true;
	this.tzOverlayToPlacement = false;
    this.mtfNoFlush = false;

	function _isValidStartTime(startTime) {
		return this._isValidNumber(startTime);
	}
	this._isValidStartTime = _isValidStartTime;

	function _convertDuration(duration) {
		if(duration) {
			duration = duration.toString().toUpperCase();
			switch(duration) {
				case "AUTO": return "AUTO";
				case "NONE": return 0;
				default: return (this._isValidNumber(duration) ? eval(duration) : 0);
			}
		}
		return 0;
	}
	this._convertDuration = _convertDuration;

	function _isValidNumber(num) {
		var floatNum = parseFloat(num);
		if(isNaN(floatNum) || floatNum < 0)
			return false;
		return ((floatNum == num) ? true : false);
	}
	this._isValidNumber = _isValidNumber;

	function isPartOfArrayPrototype(subject) {
		for(var prototypeItem in Array.prototype) {
			if(prototypeItem == subject) {
				return true;
			}
		}
		return false;
	}
	this.isPartOfArrayPrototype = isPartOfArrayPrototype;

	function isWindows() {
		return (navigator.appVersion.indexOf("Windows") != -1);
	}
	this.isWindows = isWindows;

	function isFirefox() {
		var appUserAgent = navigator.userAgent.toUpperCase();
		if(appUserAgent.indexOf("GECKO") != -1) {
			if(appUserAgent.indexOf("FIREFOX") != -1) {
				var version = parseFloat(appUserAgent.substr(appUserAgent.lastIndexOf("/") + 1));
				return (version >= 1) ? true : false;
			}
			else if(appUserAgent.indexOf("NETSCAPE") != -1) {
				var version = parseFloat(appUserAgent.substr(appUserAgent.lastIndexOf("/") + 1));
				return (version >= 8) ? true : false;
			}
		}
		else
			return false;
	}
	this.isFirefox = isFirefox;

	function isSafari() {
		return (navigator.appVersion.indexOf("Safari") != -1) && parseFloat(navigator.userAgent.split('/')[3])>=312.6;
	}
	this.isSafari = isSafari;

	function isMac() {
		return (navigator.appVersion.indexOf("Mac") != -1);
	}
	this.isMac = isMac;

	function isInternetExplorer() {
		return (navigator.appVersion.indexOf("MSIE") != -1 && navigator.userAgent.indexOf("Opera") < 0);
	}
	this.isInternetExplorer = isInternetExplorer;

	function getIEVersion() {
		var version = 0;
		if(this.isInternetExplorer()) {
			var key = "MSIE ";
			var index = navigator.appVersion.indexOf(key) + key.length;
			var subString = navigator.appVersion.substr(index);
			version = parseFloat(subString.substring(0, subString.indexOf(";")));
		}
		return version;
	}
	this.getIEVersion = getIEVersion;

	function getPlatform() {
		return navigator.platform;
	}
	this.getPlatform = getPlatform;

	function getPluginInfo() {
		return (this.isInternetExplorer() && this.isWindows()) ? this._getIeWindowsVersion() : this._detectNonWindows();
	}
	this.getPluginInfo = getPluginInfo;

	function _getIeWindowsVersion() {
		var lineFeed = "\r\n";
		var majorVersion = 10;
		var str = 'mtfCounter = ' + majorVersion + lineFeed +
				  'mtfIsOk = ' + false + lineFeed +
				  'Do' + lineFeed +
					'On Error Resume Next' + lineFeed +
					'mtfIsOk = (IsObject(CreateObject(\"ShockwaveFlash.ShockwaveFlash.\" & mtfCounter & \"\")))' + lineFeed +
					'If mtfIsOk = true Then Exit Do' + lineFeed +
					'mtfCounter = mtfCounter - 1' + lineFeed +
				 'Loop While mtfCounter > 0';
		window.execScript(str, "VBScript");
		return (mtfIsOk == true) ? mtfCounter : 0;
	}
	this._getIeWindowsVersion = _getIeWindowsVersion;

	function _detectNonWindows() {
		var flashVersion = 0;
		var key = "Shockwave Flash";
		if(navigator.plugins && (navigator.plugins["Shockwave Flash 2.0"] || navigator.plugins[key])) {
			var version2Offset = navigator.plugins["Shockwave Flash 2.0"] ? " 2.0" : "";
			var flashDescription = navigator.plugins[key + version2Offset].description;
			var keyIndex = flashDescription.indexOf(key) + (key.length+1);
			var majorVersion = flashDescription.substring(keyIndex, keyIndex+1);
			var minorVersion = "0";
			var minorVersionKey = "r";
			var minorVersionKeyIndex = flashDescription.indexOf(minorVersionKey ) + (minorVersionKey.length);
			if(minorVersionKeyIndex > 1) {
				minorVersion = flashDescription.substring(minorVersionKeyIndex)
			}
			flashVersion = parseFloat(majorVersion + "." + minorVersion);
			if(flashVersion > 6.0 && flashVersion < 6.65) {
				flashVersion = 0 ;
			}
		}
		return flashVersion;
	}
	this._detectNonWindows = _detectNonWindows;
	function toObject(variableName) {
		if(document.layers) {
			return (document.layers[variableName]) ? eval(document.layers[variableName]) : null;
		}
		else if(document.all && !document.getElementById) {
			return (eval("window." + variableName)) ? eval("window." + variableName) : null;
		}
		else if(document.getElementById && document.body.style) {
			return (document.getElementById(variableName)) ? eval(document.getElementById(variableName)) : null;
		}
	}
	this.toObject = toObject;

	function getObjectHtml() {
		var ret = this.getArgs(arguments);
		return this.generateObj(ret.objAttrs, ret.params, ret.embedAttrs);
	}
	this.getObjectHtml = getObjectHtml;

	function getArgs(args) {
		var ret = new Object();
		ret.embedAttrs = new Object();
		ret.params = new Object();
		ret.objAttrs = new Object();
		var queryString="";
		for(var i=0; i < args.length; i=i+2) {
			var currArg = args[i].toLowerCase();
			switch(currArg) {
				case "codebase":
				case "pluginspage":
				case "type":
				case "classid":
				case "minversion":
					break;
				case "src":
				case "movie":
					ret.params["movie"] = ret.embedAttrs["src"] = args[i+1];
					break;
				case "querystring":
					queryString=args[i+1] = args[i+1] + '&br=' + escape(this.getBrowser()) + '&os=' + escape(this.getOS());
					break;
				case "width":
				case "height":
				case "align":
				case "vspace":
				case "hspace":
				case "class":
				case "title":
				case "accesskey":
				case "name":
				case "id":
				case "tabindex":
				case "alt":
					ret.embedAttrs[args[i]] = ret.objAttrs[args[i]] = args[i+1];
					break;
				case "swliveconnect":
					ret.embedAttrs[args[i]] = args[i+1];
					break;
				case "play":
					if(!this.isTzCreative) {
						ret.embedAttrs[args[i]] = ret.params[args[i]] = args[i+1];
					}
					break;
				default:
					ret.embedAttrs[args[i]] = ret.params[args[i]] = args[i+1];
			}
		}
		if(this.getPluginInfo()>=6){
			ret.params["FlashVars"] = ret.embedAttrs["FlashVars"] = queryString;
		}
		else{
			var url=ret.params["movie"];
			ret.params["movie"] = ret.embedAttrs["src"] =url+"?"+queryString;
		}
		ret.objAttrs["classid"] = "clsid:D27CDB6E-AE6D-11cf-96B8-444553540000";
		ret.embedAttrs["type"] = "application/x-shockwave-flash";
		ret.params["allowScriptAccess"] = "always";
		ret.embedAttrs["allowScriptAccess"] = "always";
		return ret;
	}
	this.getArgs = getArgs;

	function generateObj(objAttrs, params, embedAttrs) {
		var str = "";
		if(this.isInternetExplorer()) {
			str += '<object ';
			for (var i in objAttrs) {
				if(!this.isPartOfArrayPrototype(i)) {
					str += i + '="' + objAttrs[i] + '" ';
				}
			}
			str += '>';
			for (var i in params) {
				if(!this.isPartOfArrayPrototype(i)) {
					str += '<param name="' + i + '" value="' + params[i] + '" /> ';
				}
			}
		}
		str += '<embed ';
		for (var i in embedAttrs) {
			if(!this.isPartOfArrayPrototype(i)) {
				str += i + '="' + embedAttrs[i] + '" ';
			}
		}
		str += ' ></embed>';
		if(this.isInternetExplorer()) {
			str += '</object>';
		}
		return str;
	}
	this.generateObj = generateObj;

	function getCallbackObjectIndex(obj) {
		for(var i = 0; i < dartCallbackObjects.length; i++) {
			if(dartCallbackObjects[i] == obj)
				return i;
		}
		dartCallbackObjects[dartCallbackObjects.length] = obj;
		return dartCallbackObjects.length - 1;
	}
	this.getCallbackObjectIndex = getCallbackObjectIndex;

	function registerPageLoadHandler(handler, obj) {
		var callback = this.generateGlobalCallback(handler, obj);
		if(this.isInternetExplorer()) {
			if(this.isMac()) {
				this.scheduleCallbackOnLoad(handler);
			}
			else {
				if(self.document.readyState == "complete")
					callback();
				else
					self.attachEvent("onload", callback);
			}
		}
		else if(this.isFirefox()) {
			if(typeof(g_motifPageLoadedFlag) != "undefined" && g_motifPageLoadedFlag) {
				callback();
			}
			else {
				self.addEventListener("load", callback, true);
			}
		}
		else if (this.isSafari()) {
			if(self.document.readyState == "complete")
				callback();
			else
				self.addEventListener("load", callback, true);
		}
	}
	this.registerPageLoadHandler = registerPageLoadHandler;

	function registerPageUnLoadHandler(handler, obj) {
		var callback = this.generateGlobalCallback(handler, obj);
		if(this.isInternetExplorer() && this.isWindows()) {
			self.attachEvent("onunload", callback);
		}
		else if(this.isFirefox() || this.isSafari()) {
			self.addEventListener("unload", callback, true);
		}
	}
	this.registerPageUnLoadHandler = registerPageUnLoadHandler;



	function registerTimeoutHandler(timeout, handler, obj) {
		window.setTimeout(this.generateGlobalCallback(handler, obj), timeout);
	}
	this.registerTimeoutHandler = registerTimeoutHandler;

	function generateGlobalCallback(handler, obj) {
		if(obj) {
			var index = this.getCallbackObjectIndex(obj);
			handler = "if(dartCallbackObjects["+ index +"] != null) dartCallbackObjects["+ index +"]." + handler;
		}
		return new Function(handler);
	}
	this.generateGlobalCallback = generateGlobalCallback;

	function registerEventHandler(event, element, handler, obj) {
		var callback = this.generateGlobalCallback(handler, obj);
		if(this.isInternetExplorer() && this.isWindows()) {
			self.attachEvent("on" + event, callback)
		}
		else if(this.isFirefox() || this.isSafari()) {
			element.addEventListener(event, callback, false);
		}
	}
	this.registerEventHandler = registerEventHandler;

	function scheduleCallbackOnLoad(callback) {
		var onloadCheckInterval = 200;
		if(window.document.readyState.toLowerCase() == "complete")
			eval(callback);
		else
			this.registerTimeoutHandler(onloadCheckInterval, "scheduleCallbackOnLoad('" + callback + "')", this);
	}
	this.scheduleCallbackOnLoad = scheduleCallbackOnLoad;

	function getBrowser() {
		if(this.isInternetExplorer())
			return "ie";
		else if(this.isFirefox())
			return "ff";
		else if (this.isSafari())
			return "sf";
		else
			return "NOT_SUPPORTED";
	}
	this.getBrowser = getBrowser;

	function getOS() {
		if(this.isWindows())
			return "win"
		if(this.isMac())
			return "mac";
		else
			return "NOT_SUPPORTED";
	}
	this.getOS = getOS;


	this.removeArrayElement = function(array, obj) {
		for(var i = 0; i < array.length; i++) {
			if(array[i] == obj)
				array[i] = null;
		}
	}

	this.getSalign = function(expandedWidth, expandedHeight, offsetTop,offsetLeft,offsetRight,offsetBottom) {
		var salign = "";
		if (offsetTop == 0 && offsetBottom != expandedHeight) {
			salign += "T";
		} else if (offsetTop != 0 && offsetBottom == expandedHeight) {
			salign += "B";
		}
		if (offsetLeft == 0 && offsetRight != expandedWidth) {
			salign += "L";
		} else if (offsetLeft != 0 && offsetRight == expandedWidth) {
			salign += "R";
		}
		if ((salign == "T" || salign == "B") && (offsetLeft != 0 || offsetRight != expandedWidth)) {
			return "";
		}
		if ((salign == "L" || salign == "R") && (offsetTop != 0 || offsetBottom != expandedHeight)) {
			return "";
		}

		return salign;
	}

	this.usesSalignForExpanding = function(salign, wmode) {
		return ((this.isMac() && (this.isSafari() || this.isFirefox())) || (this.isWindows() && this.isFirefox() && wmode == "window")) && salign.length > 0;
	}

	this.getFlashVisibility = function() {
		return (this.isTzCreative) ? "visible" : "hidden";
	}

}  // end of DARTGlobalTemplate_XX




function DARTIFrame_20_21() {
	function setGlobals(creative) {
		creative.toolkitPreviewMode = false;
		creative.previewMode = (typeof(doubleClick_dartIsInPrevMode) != "undefined") ? (doubleClick_dartIsInPrevMode == true) : false;
		creative.debugEventsMode = (typeof(doubleclick_dartIsInDebugEventsMode) != "undefined") ? (doubleclick_dartIsInDebugEventsMode == true) : false;
	}
	this.setGlobals = setGlobals;

	function getBasicCreative(type, rid) {
		var creative = new Object();
		creative.type = type;
		creative.renderingId = rid;
		creative.assets = new Array();
		this.setGlobals(creative);
		return creative;
	}
	this.getBasicCreative = getBasicCreative;
	function getFloatingFlash(variableName, position, zIndex, left, ignoreHorizontalScroll, top, ignoreVerticalScroll, width, height, url,queryString, wmode, interstitialImage, duration, startTime, hideDropDowns, hideIFrames, hideScrollbars, hideObjects, hideApplets, adserverUrl, assetType, isMainAsset) {
		var fl = new Object();
		fl.variableName = variableName;
		fl.position = position;
		fl.zIndex = zIndex;
		fl.left = left;
		fl.ignoreHorizontalScroll = ignoreHorizontalScroll;
		fl.top = top;
		fl.ignoreVerticalScroll = ignoreVerticalScroll;
		fl.width = width;
		fl.height = height;
		fl.url = url;
		fl.queryString=queryString;
		fl.wmode = wmode;
		fl.interstitialImage = interstitialImage;
		fl.duration = duration;
		fl.startTime = startTime;
		fl.hideDropdowns = hideDropDowns;
		fl.hideIframes = hideIFrames;
		fl.hideScrollbars = hideScrollbars;
		fl.hideObjects = hideObjects;
		fl.hideApplets = hideApplets;
		fl.adserverUrl = adserverUrl;
		fl.assetType = assetType;
		fl.isMainAsset = isMainAsset;
		return fl;
	}
	this.getFloatingFlash = getFloatingFlash;
	function getFloatingCreative(variableName, position, zIndex, left, ignoreHorizontalScroll, top, ignoreVerticalScroll, width, height, url,queryString, wmode, interstitialImage, duration, startTime, hideDropDowns, hideIFrames, hideScrollbars, hideObjects, hideApplets, renderingId, adserverUrl) {
		var creative = this.getBasicCreative("FloatingFlash", renderingId);

		creative.assets["FloatingFlash"] = this.getFloatingFlash(variableName, position, zIndex, left, ignoreHorizontalScroll, top, ignoreVerticalScroll, width, height, url,queryString, wmode, interstitialImage, duration, startTime, hideDropDowns, hideIFrames, hideScrollbars, hideObjects, hideApplets, adserverUrl, "float", true);
		return creative;
	}
	this.getFloatingCreative = getFloatingCreative;

	this.processFloatingBreakout = function(creativeParameters, motifIFrameId, scheduler, isFSV, cr) {
		var creative = eval("this.getFloatingCreative(" + creativeParameters + ");");
		creative.creativeIdentifier = motifIFrameId;
		creative.isFSV = isFSV;
        creative.isTzCreative = cr.isTzCreative;
        creative.tzAutoContract = cr.tzAutoContract;
        creative.tzOverlayToPlacement = cr.tzOverlayToPlacement;
        creative.mtfNoFlush = cr.mtfNoFlush;
        
		var cid = creative.creativeIdentifier;
		var globalTemplate = new DARTGlobalTemplate_20_21(creative.creativeIdentifier);
        globalTemplate.isTzCreative = creative.isTzCreative;
        globalTemplate.tzAutoContract = cr.tzAutoContract;
        globalTemplate.tzOverlayToPlacement = cr.tzOverlayToPlacement;
        globalTemplate.mtfNoFlush = cr.mtfNoFlush;
        dartGlobalTemplateObjects[creative.creativeIdentifier] = globalTemplate;
        
		var manager = scheduler.getDisplayManager(creative);
		scheduler.displayCreative(creative, manager);
		dartCreativeDisplayManagers[cid].doNotAdjustIFrame(creative.assets["FloatingFlash"].variableName, motifIFrameId);
	}

	function getExpandingDivElement(ec, globalTemplate) {
		var top = "" + (0 - ec.offsetTop) + "px";
		var left = "" + (0 - ec.offsetLeft) + "px";
		var adDiv = document.createElement("DIV");
		adDiv.id = "DIV_" + ec.variableName;
		adDiv.style.position = "absolute";
		adDiv.style.top = top;
		adDiv.style.left = left;
		adDiv.style.visibility = globalTemplate.getFlashVisibility();
		adDiv.style.zIndex = ec.zIndex;
		adDiv.style.textAlign = "left";

		if(globalTemplate.usesSalignForExpanding(ec.salign, ec.wmode)) {
			adDiv.style.width = ec.expandedWidth + "px";
			adDiv.style.height = ec.expandedHeight + "px";
		}

		var mouseOutMethod = "dartCreativeDisplayManagers['" + globalTemplate.creativeIdentifier + "'].onMouseOut('" + ec.variableName + "');";
		adDiv.onmouseout = new Function(mouseOutMethod);

		var mouseOverMethod = "dartCreativeDisplayManagers['" + globalTemplate.creativeIdentifier + "'].onMouseOver('" + ec.variableName + "');";
		adDiv.onmouseover = new Function(mouseOverMethod);



		var movie = ec.url;
		var queryString= ec.queryString + '&td=' + escape(self.location.hostname) + "&wmode=" + ec.wmode;
		queryString+=(globalTemplate.usesSalignForExpanding(ec.salign, ec.wmode)) ? '&scaleMode=noScale' : '';
		var html = globalTemplate.getObjectHtml("id", "FLASH_" + ec.variableName, "name", "FLASH_" + ec.variableName,
									 "WIDTH", ec.expandedWidth, "HEIGHT", ec.expandedHeight,
									 "movie", movie, "quality", "high", "wmode", ec.wmode, "salign", ec.salign,
									 "queryString",queryString, "play", "false"
									 );
		adDiv.innerHTML = html;
		ec.flashHtml = html;
		return adDiv;
	}
	this.getExpandingDivElement = getExpandingDivElement;
	function getExpandingCreative(variableName, wmode, zIndex, width, height, expWidth, expHeight, offsetTop, offsetLeft, offsetRight, offsetBottom, salign, url, queryString, duration, startTime, hideDropDowns, hideIFrames, hideScrollbars, hideObjects, hideApplets, renderingId, adserverUrl, pushContents, animationTime, displayInline) {
		var creative = this.getBasicCreative("ExpandingFlash", renderingId);
		var exp = new Object();
		exp.variableName = variableName;
		exp.wmode = wmode;
		exp.zIndex = zIndex;
		exp.width = width;
		exp.height = height;
		exp.expandedWidth = expWidth;
		exp.expandedHeight = expHeight;
		exp.offsetTop = offsetTop;
		exp.offsetLeft = offsetLeft;
		exp.offsetRight = offsetRight;
		exp.offsetBottom = offsetBottom;
		exp.salign = salign;
		exp.url = url;
		exp.queryString=queryString;
		exp.duration = duration;
		exp.startTime = startTime;
		exp.hideDropdowns = hideDropDowns;
		exp.hideIframes = hideIFrames;
		exp.hideScrollbars = hideScrollbars;
		exp.hideObjects = hideObjects;
		exp.hideApplets = hideApplets;
		exp.adserverUrl = adserverUrl;
		exp.placeholderIframe = -1;
		exp.assetType = "expando";
		exp.isMainAsset = true;
		exp.pushContents = pushContents;
		exp.animationTime = animationTime;
		exp.displayInline = displayInline;
		creative.assets["ExpandingFlash"] = exp;
		return creative;
	}
	this.getExpandingCreative = getExpandingCreative;

	this.processExpandingBreakout = function(creativeParameters, motifIFrameId, scheduler, mediaServer, isFSV, isMsnDapIF, cr) {
		try {
			var adIFrame = this.getAdIFrame(motifIFrameId);
			if(adIFrame == null)
				return;
			var creative = eval("this.getExpandingCreative(" + creativeParameters + ");");
			creative.creativeIdentifier = motifIFrameId;
			creative.isFSV = isFSV;
			creative.isTzCreative = cr.isTzCreative;
			creative.tzAutoContract = cr.tzAutoContract;
			creative.tzOverlayToPlacement = cr.tzOverlayToPlacement;
            creative.mtfNoFlush = cr.mtfNoFlush;

			var globalTemplate = new DARTGlobalTemplate_20_21(creative.creativeIdentifier);
			globalTemplate.isTzCreative = creative.isTzCreative;
			globalTemplate.tzAutoContract = cr.tzAutoContract;
			globalTemplate.tzOverlayToPlacement = cr.tzOverlayToPlacement;
            globalTemplate.mtfNoFlush = cr.mtfNoFlush;
			dartGlobalTemplateObjects[creative.creativeIdentifier] = globalTemplate;
			var ec = creative.assets["ExpandingFlash"];
			ec.placeholderIframe = motifIFrameId;

			var divElement = document.createElement("DIV");
			divElement.id = "OUTER_DIV_" + ec.variableName;
			divElement.style.position = "relative";
			divElement.style.zIndex = ec.zIndex;
			var parentNode = adIFrame.parentNode;
			if(isMsnDapIF) {
				divElement.style.display = "block";
				this.adjustParentOverflowStyle(globalTemplate, parentNode);
			}

			var tableElement = document.createElement("TABLE");
			tableElement.style.width = ec.width + "px";
			tableElement.style.height = ec.height + "px";
			if(ec.displayInline) {
				tableElement.style.display = "inline";
			}
			tableElement.cellPadding = 0;
			tableElement.cellSpacing = 0;
			tableElement.border = 0;
			var tableBody = document.createElement("TBODY");
			var rowElement = document.createElement("TR");
			var colElement = document.createElement("TD");
			rowElement.style.padding = "0px";
			rowElement.style.margin = "0px";
			rowElement.style.borderStyle = "none";
			rowElement.style.borderWidth = "0px";
			colElement.style.padding = "0px";
			colElement.style.margin = "0px";
			colElement.style.borderStyle = "none";
			colElement.style.borderWidth = "0px";
			colElement.appendChild(divElement);
			rowElement.appendChild(colElement);
			tableBody.appendChild(rowElement);
			tableElement.appendChild(tableBody);
			parentNode.insertBefore(tableElement, adIFrame);

			if(globalTemplate.isFirefox()) {
				var img = document.createElement("IMG");
				img.id = "EXPANDO_PLACEHOLDER_" + ec.variableName;
				img.width = parseInt(ec.width);
				img.height = parseInt(ec.height);
				if(adIFrame.width != "") {
					adIFrame.width = 0;
				}
				if(adIFrame.height != "") {
					adIFrame.height = 0;
				}
				img.src = mediaServer + "/dot.gif";
				img.style.visibility = "hidden";
				adIFrame.style.width = "0px";
				adIFrame.style.height = "0px";
				divElement.appendChild(img);
			}
			else {
				var iframe = document.createElement("IFRAME");
				iframe.id = "EXPANDO_PLACEHOLDER_" + ec.variableName;
				iframe.width = ec.width;
				iframe.height = ec.height;
				iframe.src = "about:blank";
				iframe.style.visibility = "hidden";
				adIFrame.width = 0;
				adIFrame.height = 0;
				adIFrame.style.width = "0px";
				adIFrame.style.height = "0px";
				divElement.appendChild(iframe);
			}

			var adDiv = this.getExpandingDivElement(ec, globalTemplate);
			if(isMsnDapIF) {
				adDiv.style.display = "block";
			}

			divElement.appendChild(adDiv);
			var manager = scheduler.getDisplayManager(creative);
			manager.registerCreativeElement(tableElement);
			scheduler.displayCreative(creative, manager);
		}
		catch(e){}
	}

	this.adjustParentOverflowStyle = function(globalTemplate, element) {
		var node = element;
		var browser = new DARTBrowser_20_21(globalTemplate);
		while(node) {
			if(node.tagName != "BODY" || globalTemplate.isFirefox()) {
				var css = browser.getComputedStyle(node);
				if(css.overflow == "hidden" ||
					(css.overflowX && (css.overflowX == "hidden" || css.overflowX == "auto")) ||
					(css.overflowY && (css.overflowY == "hidden" || css.overflowY == "auto"))) {
					node.style.overflow = "visible";
				}
			}
			if(node.tagName == "BODY")
				break;

			node = node.parentNode;
		}
	}

	function getAdIFrame(motifIFrameId) {
		var frames = document.getElementsByTagName("iframe");
		for(var i = 0; i < frames.length; i++) {
			if(typeof(frames[i].MotifIFrameID) != "undefined" && frames[i].MotifIFrameID == motifIFrameId)
				return frames[i];
		}
		return null;
	}
	this.getAdIFrame = getAdIFrame;
	function getFloatingWithReminderCreative(fltVarName,fltPosition,fltZIndex,fltLeft,fltIgnoreHorizontalScroll,fltTop,fltIgnoreVerticalScroll,fltWidth,fltHeight,fltURL,fltQueryString,fltWMode,interstitialImage,fltDuration,fltStartTime,hideDropDowns,hideIFrames,hideScrollbars,hideObjects,hideApplets,renderingId,adserverUrl,rmdVarName,rmdPosition,rmdZIndex,rmdLeft,rmdIgnoreHorizontalScroll,rmdTop,rmdIgnoreVerticalScroll,rmdWidth,rmdHeight,rmdURL,rmdQueryString,rmdWMode,rmdDuration,rmdStartTime) {
		var creative = this.getBasicCreative("FloatingFlashReminderFlash", renderingId);
		creative.assets["FloatingFlash"] = this.getFloatingFlash(fltVarName,fltPosition,fltZIndex,fltLeft,fltIgnoreHorizontalScroll,fltTop,fltIgnoreVerticalScroll,fltWidth,fltHeight,fltURL,fltQueryString,fltWMode,interstitialImage,fltDuration,fltStartTime,hideDropDowns,hideIFrames,hideScrollbars,hideObjects,hideApplets,adserverUrl,"float",true);
		creative.assets["ReminderFlash"] = this.getFloatingFlash(rmdVarName,rmdPosition,rmdZIndex,rmdLeft,rmdIgnoreHorizontalScroll,rmdTop,rmdIgnoreVerticalScroll,rmdWidth,rmdHeight,rmdURL,rmdQueryString,rmdWMode,"",rmdDuration,rmdStartTime,false,false,false,false,false,adserverUrl,"reminder",false);
		return creative;
	}
	this.getFloatingWithReminderCreative = getFloatingWithReminderCreative;

	function processFloatingWithReminderBreakOut(creativeParameters, motifIFrameId, scheduler, isFSV, cr) {
        var creative = eval("this.getFloatingWithReminderCreative(" + creativeParameters + ");");
        creative.creativeIdentifier = motifIFrameId;
		creative.isFSV = isFSV;
        creative.isTzCreative = cr.isTzCreative;
        creative.tzAutoContract = cr.tzAutoContract;
        creative.tzOverlayToPlacement = cr.tzOverlayToPlacement;
        creative.mtfNoFlush = cr.mtfNoFlush;
        
		var cid = creative.creativeIdentifier;
		var globalTemplate = new DARTGlobalTemplate_20_21(creative.creativeIdentifier);
        globalTemplate.isTzCreative = creative.isTzCreative;
        globalTemplate.tzAutoContract = cr.tzAutoContract;
        globalTemplate.tzOverlayToPlacement = cr.tzOverlayToPlacement;
        globalTemplate.mtfNoFlush = cr.mtfNoFlush;
        dartGlobalTemplateObjects[creative.creativeIdentifier] = globalTemplate;
        
		var manager = scheduler.getDisplayManager(creative);
		scheduler.displayCreative(creative, manager);
		dartCreativeDisplayManagers[cid].doNotAdjustIFrame(creative.assets["FloatingFlash"].variableName, motifIFrameId);
	}
	this.processFloatingWithReminderBreakOut = processFloatingWithReminderBreakOut;

	function isWaitingForBreakout(motifIFrameId) {
		var varName = this.getCreativeVariableName(motifIFrameId);
		return (eval("typeof(" + varName + ")") != "undefined");
	}
	this.isWaitingForBreakout = isWaitingForBreakout;

	function getCreativeVariableName(motifIFrameId) {
		return "dartIFrameCreative_" + motifIFrameId + "_20_21";
	}
	this.getCreativeVariableName = getCreativeVariableName;

	function doIFrameBreakout(creative, motifIFrameId) {
		var scheduler = new MotifCreativeDisplayScheduler_20_21();
		var creativeParameters = creative.creativeInfo;
		var creativeType = creative.creativeType;
		var isFSV = creative.fullScreenVideoEnabled;
		var isMsnDapIF = false;
		if(typeof(creative.MsnDapIF) != "undefined" && creative.MsnDapIF)
			isMsnDapIF = true;

		if(creativeType == "FLOATING")
			this.processFloatingBreakout(creativeParameters, motifIFrameId, scheduler, isFSV, creative);
		else if(creativeType == "EXPANDO")
			this.processExpandingBreakout(creativeParameters, motifIFrameId, scheduler, creative.mediaServer, isFSV, isMsnDapIF, creative);
		else if(creativeType == "FLOATINGWITHREMINDER")
			this.processFloatingWithReminderBreakOut(creativeParameters, motifIFrameId, scheduler, isFSV, creative);
	}
	this.doIFrameBreakout = doIFrameBreakout;

	function doIFrameBreakouts() {
		var breakoutIFrames = new Array();
		var frames = self.document.getElementsByTagName("iframe");
		for(var i = 0; i < frames.length; i++) {
			if(typeof(frames[i].MotifIFrameID) != "undefined") {
				var motifIFrameId = frames[i].MotifIFrameID;
				if(this.isWaitingForBreakout(motifIFrameId)) {
					breakoutIFrames[breakoutIFrames.length] = motifIFrameId;
				}
			}
		}

		for(var i = 0; i < breakoutIFrames.length; i++) {
			var motifIFrameId = breakoutIFrames[i];
			var creative = eval(getCreativeVariableName(motifIFrameId));
			this.doIFrameBreakout(creative, motifIFrameId);
		}
	}
	this.doIFrameBreakouts = doIFrameBreakouts;

	this.removeCreative = function(creativeIdentifier, creativeType, removeOnlyJSObjects) {
		var manager = dartCreativeDisplayManagers[creativeIdentifier];
		if(typeof(manager) == "undefined" || manager == null)
			return;

		if(creativeType == "EXPANDO" && !removeOnlyJSObjects)
			this.revertExpandingAdChanges(creativeIdentifier, manager);

		manager.globalTemplate.removeArrayElement(dartCallbackObjects, manager);
		manager.deleteCreative(removeOnlyJSObjects);
		dartCreativeDisplayManagers[creativeIdentifier] = null;
	}


	this.revertExpandingAdChanges = function(creativeIdentifier, manager) {
		var frames = self.document.getElementsByTagName("iframe");
		for(var j = 0; j < frames.length; j++) {
			if(typeof(frames[j].MotifIFrameID) != "undefined" && frames[j].MotifIFrameID == creativeIdentifier) {
				frames[j].width = manager.creative.assets["ExpandingFlash"].width;
				frames[j].height = manager.creative.assets["ExpandingFlash"].height;
				frames[j].style.width = manager.creative.assets["ExpandingFlash"].width + "px";
				frames[j].style.height = manager.creative.assets["ExpandingFlash"].height + "px";
				break;
			}
		}
	}

}   // end of DARTIFrame_XX




function DARTPopup_20_21() {
	function processPopupCode() {
		var objectHtml = unescape(dartObjectHtml);
		var popupDiv = document.getElementById("DIV_POPUP");
		if(popupDiv != null)
			popupDiv.innerHTML = objectHtml;

		var creative = new Object();
		creative.type = "Pop";
		creative.renderingId = dartRenderingId;
		creative.creativeIdentifier = dartCreativeIdentifier;
		creative.previewMode = (typeof(doubleClick_dartIsInPrevMode) != "undefined") ? (doubleClick_dartIsInPrevMode == true) : false;
		creative.debugEventsMode = (typeof(doubleclick_dartIsInDebugEventsMode) != "undefined") ? (doubleclick_dartIsInDebugEventsMode == true) : false;
		creative.isFSV = (typeof(doubleClick_dartIsFSV) != "undefined") ? (doubleClick_dartIsFSV == true) : false;
        creative.mtfNoFlush = (typeof(doubleClick_mtfNoFlush) != "undefined") ? (doubleClick_mtfNoFlush == true) : false;
		creative.toolkitPreviewMode = false;
		creative.assets = new Array();

		var popFlash = new Object();
		popFlash.variableName = dartVariableName;
		popFlash.duration = popupDuration;
		popFlash.adserverUrl = dartAdserverUrl;
		popFlash.assetType = "pop";
		popFlash.isMainAsset = true;
		creative.assets["PopFlash"] = popFlash;
		dartGlobalTemplateObjects[dartCreativeIdentifier] = new DARTGlobalTemplate_20_21(dartCreativeIdentifier);
		var scheduler = new MotifCreativeDisplayScheduler_20_21();
		var manager = scheduler.getDisplayManager(creative);
		if (typeof(dartIsOverlay) != "undefined" && dartIsOverlay) {
			var dartClose = parent.dartGlobalTemplateObjects[dartCreativeIdentifier].generateGlobalCallback("closeSelfPopup()",manager);
			document.getElementById('FLASH_' + dartVariableName).onmouseout = dartClose;
		}
		if (typeof(dartIsPopup) != "undefined") {
			globalTemplate.registerPageUnLoadHandler("unloadPopup()", manager);
		}
		scheduler.displayCreative(creative, manager);
	}
	this.processPopupCode = processPopupCode;

}  // end of DARTPopup_XX


var globalTemplate = new DARTGlobalTemplate_20_21();
if(typeof(dartIsPopup) != "undefined") {
	globalTemplate.registerPageLoadHandler("(new DARTPopup_20_21()).processPopupCode()", null);
}
else {
	if(globalTemplate.isFirefox()||globalTemplate.isSafari())
		new DARTIFrame_20_21().doIFrameBreakouts();
	else
		globalTemplate.registerPageLoadHandler("(new DARTIFrame_20_21()).doIFrameBreakouts()", null);
}

var dartGlobalTemplateLoaded_20_21 = true;
